/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class SegmentReloadMessage
extends Message {
    public static final String RELOAD_SEGMENT_MSG_SUB_TYPE = "RELOAD_SEGMENT";
    private static final String FORCE_DOWNLOAD_KEY = "forceDownload";
    private static final String SEGMENT_NAMES = "segmentNames";

    public SegmentReloadMessage(String tableNameWithType, boolean forceDownload) {
        this(tableNameWithType, null, forceDownload);
    }

    public SegmentReloadMessage(String tableNameWithType, @Nullable List<String> segmentNames, boolean forceDownload) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setResourceName(tableNameWithType);
        this.setMsgSubType(RELOAD_SEGMENT_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setBooleanField(FORCE_DOWNLOAD_KEY, forceDownload);
        if (CollectionUtils.isNotEmpty(segmentNames)) {
            this.setPartitionName(segmentNames.get(0));
            znRecord.setListField(SEGMENT_NAMES, segmentNames);
        }
    }

    public SegmentReloadMessage(Message message) {
        super(message.getRecord());
        String msgSubType = message.getMsgSubType();
        Preconditions.checkArgument((boolean)msgSubType.equals(RELOAD_SEGMENT_MSG_SUB_TYPE), (Object)("Invalid message sub type: " + msgSubType + " for SegmentReloadMessage"));
    }

    public boolean shouldForceDownload() {
        return this.getRecord().getBooleanField(FORCE_DOWNLOAD_KEY, false);
    }

    @Nullable
    public List<String> getSegmentList() {
        return this.getRecord().getListField(SEGMENT_NAMES);
    }
}

