/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.EqualityUtils;

@JsonPropertyOrder(value={"columnNames", "columnDataTypes"})
public class DataSchema {
    private final String[] _columnNames;
    private final ColumnDataType[] _columnDataTypes;
    private ColumnDataType[] _storedColumnDataTypes;
    public static final DataSchema EXPLAIN_RESULT_SCHEMA = new DataSchema(new String[]{"Operator", "Operator_Id", "Parent_Id"}, new ColumnDataType[]{ColumnDataType.STRING, ColumnDataType.INT, ColumnDataType.INT});

    @JsonCreator
    public DataSchema(@JsonProperty(value="columnNames") String[] columnNames, @JsonProperty(value="columnDataTypes") ColumnDataType[] columnDataTypes) {
        this._columnNames = columnNames;
        this._columnDataTypes = columnDataTypes;
    }

    public int size() {
        return this._columnNames.length;
    }

    public String getColumnName(int index) {
        return this._columnNames[index];
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public ColumnDataType getColumnDataType(int index) {
        return this._columnDataTypes[index];
    }

    public ColumnDataType[] getColumnDataTypes() {
        return this._columnDataTypes;
    }

    @JsonIgnore
    public ColumnDataType[] getStoredColumnDataTypes() {
        ColumnDataType[] storedColumnDataTypes = this._storedColumnDataTypes;
        if (storedColumnDataTypes == null) {
            int numColumns = this._columnDataTypes.length;
            storedColumnDataTypes = new ColumnDataType[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                storedColumnDataTypes[i] = this._columnDataTypes[i].getStoredType();
            }
            this._storedColumnDataTypes = storedColumnDataTypes;
        }
        return storedColumnDataTypes;
    }

    public boolean isTypeCompatibleWith(DataSchema anotherDataSchema) {
        if (!Arrays.equals(this._columnNames, anotherDataSchema._columnNames)) {
            return false;
        }
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            if (this._columnDataTypes[i].isCompatible(anotherDataSchema._columnDataTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static DataSchema upgradeToCover(DataSchema originalSchema, DataSchema anotherDataSchema) {
        int numColumns = originalSchema._columnDataTypes.length;
        ColumnDataType[] columnDataTypes = new ColumnDataType[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            ColumnDataType thisColumnDataType = originalSchema._columnDataTypes[i];
            ColumnDataType thatColumnDataType = anotherDataSchema._columnDataTypes[i];
            if (thisColumnDataType != thatColumnDataType) {
                if (thisColumnDataType.isArray()) {
                    if (thisColumnDataType.isWholeNumberArray() && thatColumnDataType.isWholeNumberArray()) {
                        columnDataTypes[i] = ColumnDataType.LONG_ARRAY;
                        continue;
                    }
                    columnDataTypes[i] = ColumnDataType.DOUBLE_ARRAY;
                    continue;
                }
                if (thisColumnDataType.isWholeNumber() && thatColumnDataType.isWholeNumber()) {
                    columnDataTypes[i] = ColumnDataType.LONG;
                    continue;
                }
                columnDataTypes[i] = ColumnDataType.DOUBLE;
                continue;
            }
            columnDataTypes[i] = originalSchema._columnDataTypes[i];
        }
        return new DataSchema(originalSchema._columnNames, columnDataTypes);
    }

    public byte[] toBytes() throws IOException {
        byte[] bytes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int length = this._columnNames.length;
        dataOutputStream.writeInt(length);
        for (String string : this._columnNames) {
            bytes = string.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        for (ColumnDataType columnDataType : this._columnDataTypes) {
            bytes = columnDataType.name().getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static DataSchema fromBytes(ByteBuffer buffer) throws IOException {
        byte[] bytes;
        int length;
        int i;
        int numColumns = buffer.getInt();
        String[] columnNames = new String[numColumns];
        ColumnDataType[] columnDataTypes = new ColumnDataType[numColumns];
        for (i = 0; i < numColumns; ++i) {
            length = buffer.getInt();
            bytes = new byte[length];
            buffer.get(bytes);
            columnNames[i] = new String(bytes, StandardCharsets.UTF_8);
        }
        for (i = 0; i < numColumns; ++i) {
            length = buffer.getInt();
            bytes = new byte[length];
            buffer.get(bytes);
            columnDataTypes[i] = ColumnDataType.valueOf(new String(bytes, StandardCharsets.UTF_8));
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    public DataSchema clone() {
        return new DataSchema((String[])this._columnNames.clone(), (ColumnDataType[])this._columnDataTypes.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            stringBuilder.append(this._columnNames[i]).append('(').append((Object)this._columnDataTypes[i]).append(')').append(',');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        return stringBuilder.toString();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof DataSchema) {
            DataSchema anotherDataSchema = (DataSchema)anObject;
            return Arrays.equals(this._columnNames, anotherDataSchema._columnNames) && Arrays.equals((Object[])this._columnDataTypes, (Object[])anotherDataSchema._columnDataTypes);
        }
        return false;
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf((int)Arrays.hashCode(this._columnNames), (int)Arrays.hashCode((Object[])this._columnDataTypes));
    }

    public static final class ColumnDataType
    extends Enum<ColumnDataType> {
        public static final /* enum */ ColumnDataType INT = new ColumnDataType(0);
        public static final /* enum */ ColumnDataType LONG = new ColumnDataType(0L);
        public static final /* enum */ ColumnDataType FLOAT = new ColumnDataType(Float.valueOf(0.0f));
        public static final /* enum */ ColumnDataType DOUBLE = new ColumnDataType(0.0);
        public static final /* enum */ ColumnDataType BIG_DECIMAL = new ColumnDataType(BigDecimal.ZERO);
        public static final /* enum */ ColumnDataType BOOLEAN = new ColumnDataType(INT, 0);
        public static final /* enum */ ColumnDataType TIMESTAMP = new ColumnDataType(LONG, 0L);
        public static final /* enum */ ColumnDataType STRING = new ColumnDataType("");
        public static final /* enum */ ColumnDataType JSON = new ColumnDataType(STRING, "");
        public static final /* enum */ ColumnDataType BYTES = new ColumnDataType(new ByteArray(new byte[0]));
        public static final /* enum */ ColumnDataType OBJECT = new ColumnDataType(null);
        public static final /* enum */ ColumnDataType INT_ARRAY = new ColumnDataType(new int[0]);
        public static final /* enum */ ColumnDataType LONG_ARRAY = new ColumnDataType(new long[0]);
        public static final /* enum */ ColumnDataType FLOAT_ARRAY = new ColumnDataType(new float[0]);
        public static final /* enum */ ColumnDataType DOUBLE_ARRAY = new ColumnDataType(new double[0]);
        public static final /* enum */ ColumnDataType BOOLEAN_ARRAY = new ColumnDataType(INT_ARRAY, new int[0]);
        public static final /* enum */ ColumnDataType TIMESTAMP_ARRAY = new ColumnDataType(LONG_ARRAY, new long[0]);
        public static final /* enum */ ColumnDataType STRING_ARRAY = new ColumnDataType(new String[0]);
        public static final /* enum */ ColumnDataType BYTES_ARRAY = new ColumnDataType(new byte[0][]);
        private static final EnumSet<ColumnDataType> NUMERIC_TYPES;
        private static final Ordering<ColumnDataType> NUMERIC_TYPE_ORDERING;
        private static final EnumSet<ColumnDataType> INTEGRAL_TYPES;
        private static final EnumSet<ColumnDataType> ARRAY_TYPES;
        private static final EnumSet<ColumnDataType> NUMERIC_ARRAY_TYPES;
        private static final EnumSet<ColumnDataType> INTEGRAL_ARRAY_TYPES;
        private final ColumnDataType _storedColumnDataType;
        private final Object _nullPlaceholder;
        private static final /* synthetic */ ColumnDataType[] $VALUES;

        public static ColumnDataType[] values() {
            return (ColumnDataType[])$VALUES.clone();
        }

        public static ColumnDataType valueOf(String name) {
            return Enum.valueOf(ColumnDataType.class, name);
        }

        private ColumnDataType(Object nullPlaceHolder) {
            this._storedColumnDataType = this;
            this._nullPlaceholder = nullPlaceHolder;
        }

        private ColumnDataType(ColumnDataType storedColumnDataType, Object nullPlaceHolder) {
            this._storedColumnDataType = storedColumnDataType;
            this._nullPlaceholder = nullPlaceHolder;
        }

        public Object getNullPlaceholder() {
            return this._nullPlaceholder;
        }

        public ColumnDataType getStoredType() {
            return this._storedColumnDataType;
        }

        public boolean isNumber() {
            return NUMERIC_TYPES.contains((Object)this);
        }

        public boolean isWholeNumber() {
            return INTEGRAL_TYPES.contains((Object)this);
        }

        public boolean isArray() {
            return ARRAY_TYPES.contains((Object)this);
        }

        public boolean isNumberArray() {
            return NUMERIC_ARRAY_TYPES.contains((Object)this);
        }

        public boolean isWholeNumberArray() {
            return INTEGRAL_ARRAY_TYPES.contains((Object)this);
        }

        public boolean isCompatible(ColumnDataType anotherColumnDataType) {
            return this == anotherColumnDataType || this.isNumber() && anotherColumnDataType.isNumber() || this.isNumberArray() && anotherColumnDataType.isNumberArray();
        }

        public boolean isSuperTypeOf(ColumnDataType subTypeCandidate) {
            if (this.isNumber() && subTypeCandidate.isNumber() && this != BIG_DECIMAL && subTypeCandidate != BIG_DECIMAL) {
                return NUMERIC_TYPE_ORDERING.max((Object)this, (Object)subTypeCandidate) == this;
            }
            return this == subTypeCandidate;
        }

        public FieldSpec.DataType toDataType() {
            switch (this) {
                case INT: {
                    return FieldSpec.DataType.INT;
                }
                case LONG: {
                    return FieldSpec.DataType.LONG;
                }
                case FLOAT: {
                    return FieldSpec.DataType.FLOAT;
                }
                case DOUBLE: {
                    return FieldSpec.DataType.DOUBLE;
                }
                case BIG_DECIMAL: {
                    return FieldSpec.DataType.BIG_DECIMAL;
                }
                case BOOLEAN: {
                    return FieldSpec.DataType.BOOLEAN;
                }
                case TIMESTAMP: {
                    return FieldSpec.DataType.TIMESTAMP;
                }
                case STRING: {
                    return FieldSpec.DataType.STRING;
                }
                case JSON: {
                    return FieldSpec.DataType.JSON;
                }
                case BYTES: {
                    return FieldSpec.DataType.BYTES;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert ColumnDataType: %s to DataType", new Object[]{this}));
        }

        public Serializable convert(Object value) {
            switch (this) {
                case INT: {
                    return Integer.valueOf(((Number)value).intValue());
                }
                case LONG: {
                    return Long.valueOf(((Number)value).longValue());
                }
                case FLOAT: {
                    return Float.valueOf(((Number)value).floatValue());
                }
                case DOUBLE: {
                    return Double.valueOf(((Number)value).doubleValue());
                }
                case BIG_DECIMAL: {
                    return (BigDecimal)value;
                }
                case BOOLEAN: {
                    return Boolean.valueOf((Integer)value == 1);
                }
                case TIMESTAMP: {
                    return new Timestamp((Long)value);
                }
                case STRING: 
                case JSON: {
                    return value.toString();
                }
                case BYTES: {
                    return ((ByteArray)value).getBytes();
                }
                case INT_ARRAY: {
                    return (int[])value;
                }
                case LONG_ARRAY: {
                    return ColumnDataType.toLongArray(value);
                }
                case FLOAT_ARRAY: {
                    return (float[])value;
                }
                case DOUBLE_ARRAY: {
                    return ColumnDataType.toDoubleArray(value);
                }
                case STRING_ARRAY: {
                    return (String[])value;
                }
                case BOOLEAN_ARRAY: {
                    return ColumnDataType.toBooleanArray(value);
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.toTimestampArray(value);
                }
                case BYTES_ARRAY: {
                    return (byte[][])value;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert: '%s' to type: %s", new Object[]{value, this}));
        }

        public Serializable format(Object value) {
            switch (this) {
                case BIG_DECIMAL: {
                    return ((BigDecimal)value).toPlainString();
                }
                case TIMESTAMP: {
                    assert (value instanceof Timestamp);
                    return value.toString();
                }
                case BYTES: {
                    return BytesUtils.toHexString((byte[])((byte[])value));
                }
            }
            return (Serializable)value;
        }

        public Serializable convertAndFormat(Object value) {
            switch (this) {
                case INT: {
                    return Integer.valueOf(((Number)value).intValue());
                }
                case LONG: {
                    return Long.valueOf(((Number)value).longValue());
                }
                case FLOAT: {
                    return Float.valueOf(((Number)value).floatValue());
                }
                case DOUBLE: {
                    return Double.valueOf(((Number)value).doubleValue());
                }
                case BIG_DECIMAL: {
                    return (BigDecimal)value;
                }
                case BOOLEAN: {
                    return Boolean.valueOf((Integer)value == 1);
                }
                case TIMESTAMP: {
                    return new Timestamp((Long)value).toString();
                }
                case STRING: 
                case JSON: {
                    return value.toString();
                }
                case BYTES: {
                    return ((ByteArray)value).toHexString();
                }
                case INT_ARRAY: {
                    return (int[])value;
                }
                case LONG_ARRAY: {
                    return ColumnDataType.toLongArray(value);
                }
                case FLOAT_ARRAY: {
                    return (float[])value;
                }
                case DOUBLE_ARRAY: {
                    return ColumnDataType.toDoubleArray(value);
                }
                case STRING_ARRAY: {
                    return (String[])value;
                }
                case BOOLEAN_ARRAY: {
                    return ColumnDataType.toBooleanArray(value);
                }
                case TIMESTAMP_ARRAY: {
                    return ColumnDataType.formatTimestampArray(value);
                }
                case BYTES_ARRAY: {
                    return (byte[][])value;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert and format: '%s' to type: %s", new Object[]{value, this}));
        }

        private static double[] toDoubleArray(Object value) {
            if (value instanceof double[]) {
                return (double[])value;
            }
            if (value instanceof DoubleArrayList) {
                return ((DoubleArrayList)value).elements();
            }
            if (value instanceof int[]) {
                int[] intValues = (int[])value;
                int length = intValues.length;
                double[] doubleValues = new double[length];
                for (int i = 0; i < length; ++i) {
                    doubleValues[i] = intValues[i];
                }
                return doubleValues;
            }
            if (value instanceof long[]) {
                long[] longValues = (long[])value;
                int length = longValues.length;
                double[] doubleValues = new double[length];
                for (int i = 0; i < length; ++i) {
                    doubleValues[i] = longValues[i];
                }
                return doubleValues;
            }
            float[] floatValues = (float[])value;
            int length = floatValues.length;
            double[] doubleValues = new double[length];
            for (int i = 0; i < length; ++i) {
                doubleValues[i] = floatValues[i];
            }
            return doubleValues;
        }

        private static long[] toLongArray(Object value) {
            if (value instanceof long[]) {
                return (long[])value;
            }
            int[] intValues = (int[])value;
            int length = intValues.length;
            long[] longValues = new long[length];
            for (int i = 0; i < length; ++i) {
                longValues[i] = intValues[i];
            }
            return longValues;
        }

        private static boolean[] toBooleanArray(Object value) {
            int[] ints = (int[])value;
            boolean[] booleans = new boolean[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                booleans[i] = ints[i] == 1;
            }
            return booleans;
        }

        private static Timestamp[] toTimestampArray(Object value) {
            long[] longs = (long[])value;
            Timestamp[] timestamps = new Timestamp[longs.length];
            Arrays.setAll(timestamps, i -> new Timestamp(longs[i]));
            return timestamps;
        }

        private static String[] formatTimestampArray(Object value) {
            long[] longs = (long[])value;
            String[] formatted = new String[longs.length];
            Arrays.setAll(formatted, i -> new Timestamp(longs[i]).toString());
            return formatted;
        }

        public static ColumnDataType fromDataType(FieldSpec.DataType dataType, boolean isSingleValue) {
            return isSingleValue ? ColumnDataType.fromDataTypeSV(dataType) : ColumnDataType.fromDataTypeMV(dataType);
        }

        public static ColumnDataType fromDataTypeSV(FieldSpec.DataType dataType) {
            switch (dataType) {
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case BIG_DECIMAL: {
                    return BIG_DECIMAL;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case TIMESTAMP: {
                    return TIMESTAMP;
                }
                case STRING: {
                    return STRING;
                }
                case JSON: {
                    return JSON;
                }
                case BYTES: {
                    return BYTES;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }

        public static ColumnDataType fromDataTypeMV(FieldSpec.DataType dataType) {
            switch (dataType) {
                case INT: {
                    return INT_ARRAY;
                }
                case LONG: {
                    return LONG_ARRAY;
                }
                case FLOAT: {
                    return FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return DOUBLE_ARRAY;
                }
                case BOOLEAN: {
                    return BOOLEAN_ARRAY;
                }
                case TIMESTAMP: {
                    return TIMESTAMP_ARRAY;
                }
                case STRING: {
                    return STRING_ARRAY;
                }
                case BYTES: {
                    return BYTES_ARRAY;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + dataType);
        }

        static {
            $VALUES = new ColumnDataType[]{INT, LONG, FLOAT, DOUBLE, BIG_DECIMAL, BOOLEAN, TIMESTAMP, STRING, JSON, BYTES, OBJECT, INT_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, BOOLEAN_ARRAY, TIMESTAMP_ARRAY, STRING_ARRAY, BYTES_ARRAY};
            NUMERIC_TYPES = EnumSet.of(INT, LONG, FLOAT, DOUBLE, BIG_DECIMAL);
            NUMERIC_TYPE_ORDERING = Ordering.explicit((Object)((Object)INT), (Object[])new ColumnDataType[]{LONG, FLOAT, DOUBLE});
            INTEGRAL_TYPES = EnumSet.of(INT, LONG);
            ARRAY_TYPES = EnumSet.of(INT_ARRAY, new ColumnDataType[]{LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, STRING_ARRAY, BOOLEAN_ARRAY, TIMESTAMP_ARRAY, BYTES_ARRAY});
            NUMERIC_ARRAY_TYPES = EnumSet.of(INT_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY);
            INTEGRAL_ARRAY_TYPES = EnumSet.of(INT_ARRAY, LONG_ARRAY);
        }
    }
}

