/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.common.utils.http.HttpClient;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.StringUtil;
import org.apache.pinot.spi.utils.builder.ControllerRequestURLBuilder;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadDownloadClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadDownloadClient.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SCHEMA_PATH = "/schemas";
    private static final String OLD_SEGMENT_PATH = "/segments";
    private static final String SEGMENT_PATH = "/v2/segments";
    private static final String TABLES_PATH = "/tables";
    private static final String TYPE_DELIMITER = "type=";
    private static final String START_REPLACE_SEGMENTS_PATH = "/startReplaceSegments";
    private static final String END_REPLACE_SEGMENTS_PATH = "/endReplaceSegments";
    private static final String REVERT_REPLACE_SEGMENTS_PATH = "/revertReplaceSegments";
    private static final String SEGMENT_LINEAGE_ENTRY_ID_PARAMETER = "&segmentLineageEntryId=";
    private static final String FORCE_REVERT_PARAMETER = "&forceRevert=";
    private static final String FORCE_CLEANUP_PARAMETER = "&forceCleanup=";
    private static final String RETENTION_PARAMETER = "retention=";
    private static final List<String> SUPPORTED_PROTOCOLS = Arrays.asList("http", "https");
    private final HttpClient _httpClient;

    public FileUploadDownloadClient() {
        this._httpClient = new HttpClient();
    }

    public FileUploadDownloadClient(SSLContext sslContext) {
        this._httpClient = new HttpClient(sslContext);
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    public static URI getURI(String protocol, String host, int port, String path) throws URISyntaxException {
        if (!SUPPORTED_PROTOCOLS.contains(protocol)) {
            throw new IllegalArgumentException(String.format("Unsupported protocol '%s'", protocol));
        }
        return new URI(protocol, null, host, port, path, null, null);
    }

    public static URI getURI(String protocol, String host, int port, String path, String query) throws URISyntaxException {
        if (!SUPPORTED_PROTOCOLS.contains(protocol)) {
            throw new IllegalArgumentException(String.format("Unsupported protocol '%s'", protocol));
        }
        return new URI(protocol, null, host, port, path, query, null);
    }

    @Deprecated
    public static URI getRetrieveTableConfigHttpURI(String host, int port, String rawTableName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, "/tables/" + rawTableName);
    }

    public static URI getRetrieveTableConfigURI(String protocol, String host, int port, String rawTableName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, "/tables/" + rawTableName);
    }

    @Deprecated
    public static URI getDeleteSegmentHttpUri(String host, int port, String rawTableName, String segmentName, String tableType) throws URISyntaxException {
        return new URI(StringUtil.join((String)"/", (String[])new String[]{StringUtils.chomp((String)("http://" + host + ":" + port), (String)"/"), OLD_SEGMENT_PATH, rawTableName + "/" + URIUtils.encode(segmentName) + "?type=" + tableType}));
    }

    @Deprecated
    public static URI getRetrieveAllSegmentWithTableTypeHttpUri(String host, int port, String rawTableName, String tableType) throws URISyntaxException {
        return new URI(StringUtil.join((String)"/", (String[])new String[]{StringUtils.chomp((String)("http://" + host + ":" + port), (String)"/"), OLD_SEGMENT_PATH, rawTableName + "?type=" + tableType}));
    }

    @Deprecated
    public static URI getRetrieveSchemaHttpURI(String host, int port, String schemaName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, "/schemas/" + schemaName);
    }

    public static URI getRetrieveSchemaURI(String protocol, String host, int port, String schemaName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, "/schemas/" + schemaName);
    }

    @Deprecated
    public static URI getUploadSchemaHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SCHEMA_PATH);
    }

    @Deprecated
    public static URI getUploadSchemaHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SCHEMA_PATH);
    }

    public static URI getUploadSchemaURI(String protocol, String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, SCHEMA_PATH);
    }

    public static URI getDeleteSchemaURI(String protocol, String host, int port, String schemaName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, "/schemas/" + schemaName);
    }

    public static URI getDeleteTableURI(String protocol, String host, int port, String tableName, String type, String retention) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)type)) {
            sb.append(TYPE_DELIMITER);
            sb.append(type);
        }
        if (StringUtils.isNotBlank((String)retention)) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(RETENTION_PARAMETER);
            sb.append(retention);
        }
        String query = sb.length() == 0 ? null : sb.toString();
        return FileUploadDownloadClient.getURI(protocol, host, port, "/tables/" + tableName, query);
    }

    public static URI getUploadSchemaURI(URI controllerURI) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), SCHEMA_PATH);
    }

    @Deprecated
    public static URI getOldUploadSegmentHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, OLD_SEGMENT_PATH);
    }

    @Deprecated
    public static URI getOldUploadSegmentHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, OLD_SEGMENT_PATH);
    }

    @Deprecated
    public static URI getUploadSegmentHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SEGMENT_PATH);
    }

    @Deprecated
    public static URI getUploadSegmentHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SEGMENT_PATH);
    }

    public static URI getUploadSegmentURI(String protocol, String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(protocol, host, port, SEGMENT_PATH);
    }

    public static URI getUploadSegmentURI(URI controllerURI) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), SEGMENT_PATH);
    }

    public static URI getStartReplaceSegmentsURI(URI controllerURI, String rawTableName, String tableType, boolean forceCleanup) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), "/segments/" + rawTableName + START_REPLACE_SEGMENTS_PATH, TYPE_DELIMITER + tableType + FORCE_CLEANUP_PARAMETER + forceCleanup);
    }

    public static URI getEndReplaceSegmentsURI(URI controllerURI, String rawTableName, String tableType, String segmentLineageEntryId) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), "/segments/" + rawTableName + END_REPLACE_SEGMENTS_PATH, TYPE_DELIMITER + tableType + SEGMENT_LINEAGE_ENTRY_ID_PARAMETER + segmentLineageEntryId);
    }

    public static URI getRevertReplaceSegmentsURI(URI controllerURI, String rawTableName, String tableType, String segmentLineageEntryId, boolean forceRevert) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(controllerURI.getScheme(), controllerURI.getHost(), controllerURI.getPort(), "/segments/" + rawTableName + REVERT_REPLACE_SEGMENTS_PATH, TYPE_DELIMITER + tableType + SEGMENT_LINEAGE_ENTRY_ID_PARAMETER + segmentLineageEntryId + FORCE_REVERT_PARAMETER + forceRevert);
    }

    private static HttpUriRequest getUploadFileRequest(String method, URI uri, ContentBody contentBody, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart(contentBody.getFilename(), contentBody).build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        HttpClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getDeleteFileRequest(String method, URI uri, ContentBody contentBody, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart(contentBody.getFilename(), contentBody).build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        HttpClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getAddSchemaRequest(URI uri, String schemaName, File schemaFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), headers, parameters, 600000);
    }

    private static HttpUriRequest getUploadSegmentRequest(URI uri, String segmentName, File segmentFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, segmentFile), headers, parameters, socketTimeoutMs);
    }

    private static HttpUriRequest getUploadSegmentRequest(URI uri, String segmentName, InputStream inputStream, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, inputStream), headers, parameters, socketTimeoutMs);
    }

    private static HttpUriRequest getUploadSegmentMetadataRequest(URI uri, String segmentName, File segmentFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, segmentFile), headers, parameters, socketTimeoutMs);
    }

    private static HttpUriRequest getUploadSegmentMetadataFilesRequest(URI uri, Map<String, File> metadataFiles, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int segmentUploadRequestTimeoutMs) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, File> entry : metadataFiles.entrySet()) {
            multipartEntityBuilder.addPart(entry.getKey(), FileUploadDownloadClient.getContentBody(entry.getKey(), entry.getValue()));
        }
        HttpEntity entity = multipartEntityBuilder.build();
        RequestBuilder requestBuilder = RequestBuilder.create((String)"POST").setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        HttpClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        HttpClient.setTimeout(requestBuilder, segmentUploadRequestTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getSendSegmentUriRequest(URI uri, String downloadUri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("UPLOAD_TYPE", FileUploadType.URI.toString()).setHeader("DOWNLOAD_URI", downloadUri).setHeader("Content-Type", "application/json");
        HttpClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getSendSegmentJsonRequest(URI uri, String jsonString, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("UPLOAD_TYPE", FileUploadType.JSON.toString()).setEntity((HttpEntity)new StringEntity(jsonString, ContentType.APPLICATION_JSON));
        HttpClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getStartReplaceSegmentsRequest(URI uri, String jsonRequestBody, int socketTimeoutMs, @Nullable AuthProvider authProvider) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(jsonRequestBody, ContentType.APPLICATION_JSON));
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getEndReplaceSegmentsRequest(URI uri, int socketTimeoutMs, @Nullable AuthProvider authProvider) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("Content-Type", "application/json");
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static HttpUriRequest getRevertReplaceSegmentRequest(URI uri) {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setHeader("Content-Type", "application/json");
        return requestBuilder.build();
    }

    private static HttpUriRequest getSegmentCompletionProtocolRequest(URI uri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static ContentBody getContentBody(String fileName, File file) {
        return new FileBody(file, ContentType.DEFAULT_BINARY, fileName);
    }

    private static ContentBody getContentBody(String fileName, InputStream inputStream) {
        return new InputStreamBody(inputStream, ContentType.DEFAULT_BINARY, fileName);
    }

    @Deprecated
    public SimpleHttpResponse addSchema(URI uri, String schemaName, File schemaFile) throws IOException, HttpErrorStatusException {
        return this.addSchema(uri, schemaName, schemaFile, Collections.emptyList(), Collections.emptyList());
    }

    public SimpleHttpResponse addSchema(URI uri, String schemaName, File schemaFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getAddSchemaRequest(uri, schemaName, schemaFile, headers, parameters)));
    }

    @Deprecated
    public SimpleHttpResponse updateSchema(URI uri, String schemaName, File schemaFile) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadFileRequest("PUT", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), null, null, 600000)));
    }

    public SimpleHttpResponse updateSchema(URI uri, String schemaName, File schemaFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadFileRequest("PUT", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), headers, parameters, 600000)));
    }

    public SimpleHttpResponse uploadSegmentMetadata(URI uri, String segmentName, File segmentMetadataFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadSegmentMetadataRequest(uri, segmentName, segmentMetadataFile, headers, parameters, socketTimeoutMs)));
    }

    @Deprecated
    public SimpleHttpResponse uploadSegmentMetadataFiles(URI uri, Map<String, File> metadataFiles, int segmentUploadRequestTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.uploadSegmentMetadataFiles(uri, metadataFiles, Collections.emptyList(), Collections.emptyList(), segmentUploadRequestTimeoutMs);
    }

    public SimpleHttpResponse uploadSegmentMetadataFiles(URI uri, Map<String, File> metadataFiles, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int segmentUploadRequestTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadSegmentMetadataFilesRequest(uri, metadataFiles, headers, parameters, segmentUploadRequestTimeoutMs)));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, segmentFile, headers, parameters, socketTimeoutMs)));
    }

    @Deprecated
    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, String tableName) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", tableName);
        List<BasicNameValuePair> parameters = Collections.singletonList(tableNameValuePair);
        return this.uploadSegment(uri, segmentName, segmentFile, null, parameters, 600000);
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, String tableName, TableType tableType) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", tableName);
        BasicNameValuePair tableTypeValuePair = new BasicNameValuePair("tableType", tableType.name());
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair, tableTypeValuePair);
        return this.uploadSegment(uri, segmentName, segmentFile, null, parameters, 600000);
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, String tableName, TableType tableType, boolean enableParallelPushProtection, boolean allowRefresh) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", tableName);
        BasicNameValuePair tableTypeValuePair = new BasicNameValuePair("tableType", tableType.name());
        BasicNameValuePair enableParallelPushProtectionValuePair = new BasicNameValuePair("enableParallelPushProtection", String.valueOf(enableParallelPushProtection));
        BasicNameValuePair allowRefreshValuePair = new BasicNameValuePair("allowRefresh", String.valueOf(allowRefresh));
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair, tableTypeValuePair, enableParallelPushProtectionValuePair, allowRefreshValuePair);
        return this.uploadSegment(uri, segmentName, segmentFile, null, parameters, 600000);
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, String tableName, TableType tableType) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", tableName);
        BasicNameValuePair tableTypeValuePair = new BasicNameValuePair("tableType", tableType.name());
        parameters = parameters == null ? new ArrayList<NameValuePair>() : new ArrayList<NameValuePair>(parameters);
        parameters.add((NameValuePair)tableNameValuePair);
        parameters.add((NameValuePair)tableTypeValuePair);
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, inputStream, headers, parameters, 600000)));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, inputStream, headers, parameters, socketTimeoutMs)));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream, String rawTableName) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", rawTableName);
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair);
        return this.uploadSegment(uri, segmentName, inputStream, null, parameters, 600000);
    }

    public Map<String, List<String>> getSegments(URI controllerUri, String rawTableName, @Nullable TableType tableType, boolean excludeReplacedSegments) throws Exception {
        List<String> tableTypes = tableType == null ? Arrays.asList(TableType.OFFLINE.toString(), TableType.REALTIME.toString()) : Arrays.asList(tableType.toString());
        ControllerRequestURLBuilder controllerRequestURLBuilder = ControllerRequestURLBuilder.baseUrl((String)controllerUri.toString());
        HashMap<String, List<String>> tableTypeToSegments = new HashMap<String, List<String>>();
        for (String tableTypeToFilter : tableTypes) {
            tableTypeToSegments.put(tableTypeToFilter, new ArrayList());
            String uri = controllerRequestURLBuilder.forSegmentListAPI(rawTableName, tableTypeToFilter, excludeReplacedSegments);
            RequestBuilder requestBuilder = RequestBuilder.get((String)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpClient.setTimeout(requestBuilder, 600000);
            RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)10000L, (double)2.0).attempt(() -> {
                try {
                    SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(requestBuilder.build()));
                    LOGGER.info("Response {}: {} received for GET request to URI: {}", new Object[]{response.getStatusCode(), response.getResponse(), uri});
                    tableTypeToSegments.put(tableTypeToFilter, this.getSegmentNamesFromResponse(tableTypeToFilter, response.getResponse()));
                    return true;
                }
                catch (SocketTimeoutException se) {
                    return false;
                }
                catch (HttpErrorStatusException e) {
                    if (e.getStatusCode() < 500 && e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                        LOGGER.error("Segments not found for table {} when sending request uri: {}", (Object)rawTableName, (Object)uri);
                    }
                    return false;
                }
            });
        }
        return tableTypeToSegments;
    }

    private List<String> getSegmentNamesFromResponse(String tableType, String responseString) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        JsonNode responseJsonNode = JsonUtils.stringToJsonNode((String)responseString);
        Iterator responseElements = responseJsonNode.elements();
        while (responseElements.hasNext()) {
            JsonNode responseElementJsonNode = (JsonNode)responseElements.next();
            if (!responseElementJsonNode.has(tableType)) continue;
            JsonNode jsonArray = responseElementJsonNode.get(tableType);
            Iterator elements = jsonArray.elements();
            while (elements.hasNext()) {
                JsonNode segmentJsonNode = (JsonNode)elements.next();
                segments.add(segmentJsonNode.asText());
            }
        }
        return segments;
    }

    public String uploadToSegmentStore(String uri) throws URISyntaxException, IOException, HttpErrorStatusException {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)new URI(uri)).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpClient.setTimeout(requestBuilder, 600000);
        SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(requestBuilder.build()));
        String downloadUrl = response.getResponse();
        if (downloadUrl.isEmpty()) {
            throw new HttpErrorStatusException(String.format("Returned segment download url is empty after requesting servers to upload by the path: %s", uri), response.getStatusCode());
        }
        return downloadUrl;
    }

    public SimpleHttpResponse sendSegmentUri(URI uri, String downloadUri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getSendSegmentUriRequest(uri, downloadUri, headers, parameters, socketTimeoutMs)));
    }

    @Deprecated
    public SimpleHttpResponse sendSegmentUri(URI uri, String downloadUri, String rawTableName) throws IOException, HttpErrorStatusException {
        BasicNameValuePair tableNameValuePair = new BasicNameValuePair("tableName", rawTableName);
        List<NameValuePair> parameters = Arrays.asList(tableNameValuePair);
        return this.sendSegmentUri(uri, downloadUri, null, parameters, 600000);
    }

    public SimpleHttpResponse sendSegmentJson(URI uri, String jsonString, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getSendSegmentJsonRequest(uri, jsonString, headers, parameters, socketTimeoutMs)));
    }

    @Deprecated
    public SimpleHttpResponse sendSegmentJson(URI uri, String jsonString) throws IOException, HttpErrorStatusException {
        return this.sendSegmentJson(uri, jsonString, null, null, 600000);
    }

    public SimpleHttpResponse startReplaceSegments(URI uri, StartReplaceSegmentsRequest startReplaceSegmentsRequest, @Nullable AuthProvider authProvider) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getStartReplaceSegmentsRequest(uri, JsonUtils.objectToString((Object)startReplaceSegmentsRequest), 600000, authProvider)));
    }

    public SimpleHttpResponse endReplaceSegments(URI uri, int socketTimeoutMs, @Nullable AuthProvider authProvider) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getEndReplaceSegmentsRequest(uri, socketTimeoutMs, authProvider)));
    }

    public SimpleHttpResponse revertReplaceSegments(URI uri) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getRevertReplaceSegmentRequest(uri)));
    }

    @Deprecated
    public SimpleHttpResponse sendSegmentCompletionProtocolRequest(URI uri, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendSegmentCompletionProtocolRequest(uri, Collections.emptyList(), Collections.emptyList(), socketTimeoutMs);
    }

    public SimpleHttpResponse sendSegmentCompletionProtocolRequest(URI uri, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return HttpClient.wrapAndThrowHttpException(this._httpClient.sendRequest(FileUploadDownloadClient.getSegmentCompletionProtocolRequest(uri, headers, parameters, socketTimeoutMs)));
    }

    @Deprecated
    public int downloadFile(URI uri, int socketTimeoutMs, File dest) throws IOException, HttpErrorStatusException {
        return this._httpClient.downloadFile(uri, socketTimeoutMs, dest, null, null);
    }

    @Deprecated
    public int downloadFile(URI uri, File dest) throws IOException, HttpErrorStatusException {
        return this.downloadFile(uri, dest, null);
    }

    public int downloadFile(URI uri, File dest, AuthProvider authProvider) throws IOException, HttpErrorStatusException {
        return this._httpClient.downloadFile(uri, 600000, dest, authProvider, null);
    }

    public int downloadFile(URI uri, File dest, AuthProvider authProvider, List<Header> httpHeaders) throws IOException, HttpErrorStatusException {
        return this._httpClient.downloadFile(uri, 600000, dest, authProvider, httpHeaders);
    }

    public File downloadUntarFileStreamed(URI uri, File dest, AuthProvider authProvider, List<Header> httpHeaders, long maxStreamRateInByte) throws IOException, HttpErrorStatusException {
        return this._httpClient.downloadUntarFileStreamed(uri, 600000, dest, authProvider, httpHeaders, maxStreamRateInByte);
    }

    public static List<NameValuePair> makeTableParam(String tableName) {
        return Collections.singletonList(new BasicNameValuePair("tableName", tableName));
    }

    @Override
    public void close() throws IOException {
        this._httpClient.close();
    }

    public static enum FileUploadType {
        URI,
        JSON,
        SEGMENT,
        METADATA;


        public static FileUploadType getDefaultUploadType() {
            return SEGMENT;
        }
    }

    public static class QueryParameters {
        public static final String ALLOW_REFRESH = "allowRefresh";
        public static final String ENABLE_PARALLEL_PUSH_PROTECTION = "enableParallelPushProtection";
        public static final String TABLE_NAME = "tableName";
        public static final String TABLE_TYPE = "tableType";
    }

    public static class CustomHeaders {
        public static final String UPLOAD_TYPE = "UPLOAD_TYPE";
        public static final String REFRESH_ONLY = "REFRESH_ONLY";
        public static final String DOWNLOAD_URI = "DOWNLOAD_URI";
        public static final String COPY_SEGMENT_TO_DEEP_STORE = "COPY_SEGMENT_TO_DEEP_STORE";
        public static final String SEGMENT_ZK_METADATA_CUSTOM_MAP_MODIFIER = "Pinot-SegmentZKMetadataCustomMapModifier";
        public static final String CRYPTER = "CRYPTER";
    }
}

