/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class LoggerFileServer {
    private final File _loggerRootDir;
    private final Path _loggerRootDirPath;

    public LoggerFileServer(String loggerRootDir) {
        Preconditions.checkNotNull((Object)loggerRootDir, (Object)"Logger root directory is null");
        this._loggerRootDir = new File(loggerRootDir);
        Preconditions.checkState((boolean)this._loggerRootDir.exists(), (Object)"Logger directory doesn't exists");
        this._loggerRootDirPath = Paths.get(this._loggerRootDir.getAbsolutePath(), new String[0]);
    }

    public Set<String> getAllPaths() throws IOException {
        TreeSet<String> allFiles = new TreeSet<String>();
        Files.walk(this._loggerRootDirPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> allFiles.add(f.toAbsolutePath().toString().replace(this._loggerRootDirPath.toAbsolutePath() + "/", "")));
        return allFiles;
    }

    public Response downloadLogFile(String filePath) {
        try {
            if (!this.getAllPaths().contains(filePath)) {
                throw new WebApplicationException("Invalid file path: " + filePath, Response.Status.FORBIDDEN);
            }
            File logFile = new File(this._loggerRootDir, filePath);
            if (!logFile.exists()) {
                throw new WebApplicationException("File: " + filePath + " doesn't exists", Response.Status.NOT_FOUND);
            }
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)logFile);
            builder.entity(output -> Files.copy(logFile.toPath(), output));
            builder.header("Content-Disposition", (Object)("attachment; filename=" + logFile.getName()));
            builder.header("Content-Length", (Object)logFile.length());
            return builder.build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

