/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.http.client.utils.URIBuilder;

public class RoundRobinURIProvider {
    private final URI[] _uris;
    private int _index;

    public RoundRobinURIProvider(URI originalUri) throws UnknownHostException, URISyntaxException {
        String hostName = originalUri.getHost();
        if (InetAddresses.isInetAddress((String)hostName)) {
            this._uris = new URI[]{originalUri};
        } else {
            InetAddress[] addresses = InetAddress.getAllByName(hostName);
            this._uris = new URI[addresses.length];
            URIBuilder uriBuilder = new URIBuilder(originalUri);
            for (int i = 0; i < addresses.length; ++i) {
                String ip = addresses[i].getHostAddress();
                this._uris[i] = uriBuilder.setHost(ip).build();
            }
        }
        this._index = new Random().nextInt(this._uris.length);
    }

    public int numAddresses() {
        return this._uris.length;
    }

    public URI next() {
        URI result = this._uris[this._index];
        this._index = (this._index + 1) % this._uris.length;
        return result;
    }
}

