/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);
    private static final Map<String, String> CANONICAL_NAME_TO_SPECIAL_KEY_MAP = new HashMap<String, String>();

    private RequestUtils() {
    }

    public static SqlNodeAndOptions parseQuery(String query, JsonNode request) throws SqlCompilationException {
        long parserStartTimeNs = System.nanoTime();
        SqlNodeAndOptions sqlNodeAndOptions = CalciteSqlParser.compileToSqlNodeAndOptions(query);
        RequestUtils.setOptions(sqlNodeAndOptions, request);
        sqlNodeAndOptions.setParseTimeNs(System.nanoTime() - parserStartTimeNs);
        return sqlNodeAndOptions;
    }

    @VisibleForTesting
    public static void setOptions(SqlNodeAndOptions sqlNodeAndOptions, JsonNode jsonRequest) {
        boolean enableTrace;
        Map<String, String> debugOptions;
        HashMap<String, String> queryOptions = new HashMap<String, String>();
        if (jsonRequest.has("debugOptions") && !(debugOptions = RequestUtils.getOptionsFromJson(jsonRequest, "debugOptions")).isEmpty()) {
            LOGGER.debug("Debug options are set to: {}", debugOptions);
            queryOptions.putAll(debugOptions);
        }
        if (jsonRequest.has("queryOptions")) {
            Map<String, String> queryOptionsFromJson = RequestUtils.getOptionsFromJson(jsonRequest, "queryOptions");
            queryOptions.putAll(queryOptionsFromJson);
        }
        boolean bl = enableTrace = jsonRequest.has("trace") && jsonRequest.get("trace").asBoolean();
        if (enableTrace) {
            queryOptions.put("trace", "true");
        }
        if (!queryOptions.isEmpty()) {
            LOGGER.debug("Query options are set to: {}", queryOptions);
        }
        queryOptions.put("groupByMode", "sql");
        queryOptions.put("responseFormat", "sql");
        sqlNodeAndOptions.setExtraOptions(queryOptions);
    }

    public static Expression getIdentifierExpression(String identifier) {
        Expression expression = new Expression(ExpressionType.IDENTIFIER);
        expression.setIdentifier(new Identifier(identifier));
        return expression;
    }

    public static Expression getLiteralExpression(SqlLiteral node) {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        if (node instanceof SqlNumericLiteral) {
            SqlNumericLiteral sqlNumericLiteral = (SqlNumericLiteral)node;
            if (sqlNumericLiteral.getScale() != null && sqlNumericLiteral.isInteger()) {
                literal.setLongValue(node.bigDecimalValue().longValue());
            } else {
                literal.setDoubleValue(node.bigDecimalValue().doubleValue());
            }
        } else {
            switch (node.getTypeName()) {
                case BOOLEAN: {
                    literal.setBoolValue(node.booleanValue());
                    break;
                }
                default: {
                    literal.setStringValue(StringUtils.replace((String)node.toValue(), (String)"''", (String)"'"));
                }
            }
        }
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression createNewLiteralExpression() {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression getLiteralExpression(boolean value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setBoolValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(long value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setLongValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(double value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setDoubleValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(String value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setStringValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(byte[] value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setStringValue(BytesUtils.toHexString((byte[])value));
        return expression;
    }

    public static Expression getLiteralExpression(Object object) {
        if (object instanceof Integer || object instanceof Long) {
            return RequestUtils.getLiteralExpression(((Number)object).longValue());
        }
        if (object instanceof Float || object instanceof Double) {
            return RequestUtils.getLiteralExpression(((Number)object).doubleValue());
        }
        if (object instanceof byte[]) {
            return RequestUtils.getLiteralExpression((byte[])object);
        }
        if (object instanceof Boolean) {
            return RequestUtils.getLiteralExpression((Boolean)object);
        }
        return RequestUtils.getLiteralExpression(object.toString());
    }

    public static Expression getFunctionExpression(String canonicalName) {
        assert (canonicalName.equalsIgnoreCase(RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(canonicalName)));
        Expression expression = new Expression(ExpressionType.FUNCTION);
        Function function = new Function(canonicalName);
        expression.setFunctionCall(function);
        return expression;
    }

    public static String canonicalizeFunctionName(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }

    public static String canonicalizeFunctionNamePreservingSpecialKey(String functionName) {
        String canonicalName = RequestUtils.canonicalizeFunctionName(functionName);
        return CANONICAL_NAME_TO_SPECIAL_KEY_MAP.getOrDefault(canonicalName, canonicalName);
    }

    public static String prettyPrint(Expression expression) {
        if (expression == null) {
            return "null";
        }
        if (expression.getIdentifier() != null) {
            return expression.getIdentifier().getName();
        }
        if (expression.getLiteral() != null && expression.getLiteral().isSetLongValue()) {
            return Long.toString(expression.getLiteral().getLongValue());
        }
        if (expression.getFunctionCall() != null) {
            String res = expression.getFunctionCall().getOperator() + "(";
            boolean isFirstParam = true;
            for (Expression operand : expression.getFunctionCall().getOperands()) {
                if (!isFirstParam) {
                    res = res + ", ";
                } else {
                    isFirstParam = false;
                }
                res = res + RequestUtils.prettyPrint(operand);
            }
            res = res + ")";
            return res;
        }
        return null;
    }

    public static String getTableName(PinotQuery pinotQuery) {
        while (pinotQuery.getDataSource().getSubquery() != null) {
            pinotQuery = pinotQuery.getDataSource().getSubquery();
        }
        return pinotQuery.getDataSource().getTableName();
    }

    public static Map<String, String> getOptionsFromJson(JsonNode request, String optionsKey) {
        return RequestUtils.getOptionsFromString(request.get(optionsKey).asText());
    }

    public static Map<String, String> getOptionsFromString(String optionStr) {
        return Splitter.on((char)';').omitEmptyStrings().trimResults().withKeyValueSeparator('=').split((CharSequence)optionStr);
    }

    static {
        for (FilterKind filterKind : FilterKind.values()) {
            CANONICAL_NAME_TO_SPECIAL_KEY_MAP.put(RequestUtils.canonicalizeFunctionName(filterKind.name()), filterKind.name());
        }
        CANONICAL_NAME_TO_SPECIAL_KEY_MAP.put("stdistance", "st_distance");
    }
}

