/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.spi.data.FieldSpec;

public class FunctionUtils {
    private static final Map<Class<?>, PinotDataType> PARAMETER_TYPE_MAP = new HashMap<Class<?>, PinotDataType>(){
        {
            this.put(Integer.TYPE, PinotDataType.INTEGER);
            this.put(Integer.class, PinotDataType.INTEGER);
            this.put(Long.TYPE, PinotDataType.LONG);
            this.put(Long.class, PinotDataType.LONG);
            this.put(Float.TYPE, PinotDataType.FLOAT);
            this.put(Float.class, PinotDataType.FLOAT);
            this.put(Double.TYPE, PinotDataType.DOUBLE);
            this.put(Double.class, PinotDataType.DOUBLE);
            this.put(BigDecimal.class, PinotDataType.BIG_DECIMAL);
            this.put(Boolean.TYPE, PinotDataType.BOOLEAN);
            this.put(Boolean.class, PinotDataType.BOOLEAN);
            this.put(Timestamp.class, PinotDataType.TIMESTAMP);
            this.put(String.class, PinotDataType.STRING);
            this.put(byte[].class, PinotDataType.BYTES);
            this.put(int[].class, PinotDataType.PRIMITIVE_INT_ARRAY);
            this.put(long[].class, PinotDataType.PRIMITIVE_LONG_ARRAY);
            this.put(float[].class, PinotDataType.PRIMITIVE_FLOAT_ARRAY);
            this.put(double[].class, PinotDataType.PRIMITIVE_DOUBLE_ARRAY);
            this.put(String[].class, PinotDataType.STRING_ARRAY);
            this.put(Object.class, PinotDataType.OBJECT);
        }
    };
    private static final Map<Class<?>, PinotDataType> ARGUMENT_TYPE_MAP = new HashMap<Class<?>, PinotDataType>(){
        {
            this.put(Byte.class, PinotDataType.BYTE);
            this.put(Boolean.class, PinotDataType.BOOLEAN);
            this.put(Character.class, PinotDataType.CHARACTER);
            this.put(Short.class, PinotDataType.SHORT);
            this.put(Integer.class, PinotDataType.INTEGER);
            this.put(Long.class, PinotDataType.LONG);
            this.put(Float.class, PinotDataType.FLOAT);
            this.put(Double.class, PinotDataType.DOUBLE);
            this.put(BigDecimal.class, PinotDataType.BIG_DECIMAL);
            this.put(Timestamp.class, PinotDataType.TIMESTAMP);
            this.put(String.class, PinotDataType.STRING);
            this.put(byte[].class, PinotDataType.BYTES);
            this.put(int[].class, PinotDataType.PRIMITIVE_INT_ARRAY);
            this.put(Integer[].class, PinotDataType.INTEGER_ARRAY);
            this.put(long[].class, PinotDataType.PRIMITIVE_LONG_ARRAY);
            this.put(Long[].class, PinotDataType.LONG_ARRAY);
            this.put(float[].class, PinotDataType.PRIMITIVE_FLOAT_ARRAY);
            this.put(Float[].class, PinotDataType.FLOAT_ARRAY);
            this.put(double[].class, PinotDataType.PRIMITIVE_DOUBLE_ARRAY);
            this.put(Double[].class, PinotDataType.DOUBLE_ARRAY);
            this.put(String[].class, PinotDataType.STRING_ARRAY);
            this.put(Object.class, PinotDataType.OBJECT);
            this.put(Object[].class, PinotDataType.OBJECT_ARRAY);
        }
    };
    private static final Map<Class<?>, FieldSpec.DataType> DATA_TYPE_MAP = new HashMap<Class<?>, FieldSpec.DataType>(){
        {
            this.put(Integer.TYPE, FieldSpec.DataType.INT);
            this.put(Integer.class, FieldSpec.DataType.INT);
            this.put(Long.TYPE, FieldSpec.DataType.LONG);
            this.put(Long.class, FieldSpec.DataType.LONG);
            this.put(Float.TYPE, FieldSpec.DataType.FLOAT);
            this.put(Float.class, FieldSpec.DataType.FLOAT);
            this.put(Double.TYPE, FieldSpec.DataType.DOUBLE);
            this.put(Double.class, FieldSpec.DataType.DOUBLE);
            this.put(BigDecimal.class, FieldSpec.DataType.BIG_DECIMAL);
            this.put(Boolean.TYPE, FieldSpec.DataType.BOOLEAN);
            this.put(Boolean.class, FieldSpec.DataType.BOOLEAN);
            this.put(Timestamp.class, FieldSpec.DataType.TIMESTAMP);
            this.put(String.class, FieldSpec.DataType.STRING);
            this.put(byte[].class, FieldSpec.DataType.BYTES);
            this.put(int[].class, FieldSpec.DataType.INT);
            this.put(long[].class, FieldSpec.DataType.LONG);
            this.put(float[].class, FieldSpec.DataType.FLOAT);
            this.put(double[].class, FieldSpec.DataType.DOUBLE);
            this.put(String[].class, FieldSpec.DataType.STRING);
        }
    };
    private static final Map<Class<?>, DataSchema.ColumnDataType> COLUMN_DATA_TYPE_MAP = new HashMap<Class<?>, DataSchema.ColumnDataType>(){
        {
            this.put(Integer.TYPE, DataSchema.ColumnDataType.INT);
            this.put(Integer.class, DataSchema.ColumnDataType.INT);
            this.put(Long.TYPE, DataSchema.ColumnDataType.LONG);
            this.put(Long.class, DataSchema.ColumnDataType.LONG);
            this.put(Float.TYPE, DataSchema.ColumnDataType.FLOAT);
            this.put(Float.class, DataSchema.ColumnDataType.FLOAT);
            this.put(Double.TYPE, DataSchema.ColumnDataType.DOUBLE);
            this.put(Double.class, DataSchema.ColumnDataType.DOUBLE);
            this.put(BigDecimal.class, DataSchema.ColumnDataType.BIG_DECIMAL);
            this.put(Boolean.TYPE, DataSchema.ColumnDataType.BOOLEAN);
            this.put(Boolean.class, DataSchema.ColumnDataType.BOOLEAN);
            this.put(Timestamp.class, DataSchema.ColumnDataType.TIMESTAMP);
            this.put(String.class, DataSchema.ColumnDataType.STRING);
            this.put(byte[].class, DataSchema.ColumnDataType.BYTES);
            this.put(int[].class, DataSchema.ColumnDataType.INT_ARRAY);
            this.put(long[].class, DataSchema.ColumnDataType.LONG_ARRAY);
            this.put(float[].class, DataSchema.ColumnDataType.FLOAT_ARRAY);
            this.put(double[].class, DataSchema.ColumnDataType.DOUBLE_ARRAY);
            this.put(String[].class, DataSchema.ColumnDataType.STRING_ARRAY);
            this.put(Object.class, DataSchema.ColumnDataType.OBJECT);
        }
    };

    private FunctionUtils() {
    }

    @Nullable
    public static PinotDataType getParameterType(Class<?> clazz) {
        return PARAMETER_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static PinotDataType getArgumentType(Class<?> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            return PinotDataType.COLLECTION;
        }
        return ARGUMENT_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static FieldSpec.DataType getDataType(Class<?> clazz) {
        return DATA_TYPE_MAP.get(clazz);
    }

    @Nullable
    public static DataSchema.ColumnDataType getColumnDataType(Class<?> clazz) {
        return COLUMN_DATA_TYPE_MAP.get(clazz);
    }
}

