/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConvert {
    private DateTimeFormatSpec _inputFormatSpec;
    private DateTimeFormatSpec _outputFormatSpec;
    private DateTimeGranularitySpec _granularitySpec;

    @ScalarFunction(names={"dateTimeConvert", "date_time_convert"})
    public Object dateTimeConvert(String timeValueStr, String inputFormatStr, String outputFormatStr, String outputGranularityStr) {
        if (this._inputFormatSpec == null) {
            this._inputFormatSpec = new DateTimeFormatSpec(inputFormatStr);
            this._outputFormatSpec = new DateTimeFormatSpec(outputFormatStr);
            this._granularitySpec = new DateTimeGranularitySpec(outputGranularityStr);
        }
        long timeValueMs = this._inputFormatSpec.fromFormatToMillis(timeValueStr);
        if (this._outputFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
            DateTimeFormatter outputFormatter = this._outputFormatSpec.getDateTimeFormatter();
            DateTime dateTime = new DateTime(timeValueMs, outputFormatter.getZone());
            int size = this._granularitySpec.getSize();
            switch (this._granularitySpec.getTimeUnit()) {
                case MILLISECONDS: {
                    dateTime = dateTime.withMillisOfSecond(dateTime.getMillisOfSecond() / size * size);
                    break;
                }
                case SECONDS: {
                    dateTime = dateTime.withSecondOfMinute(dateTime.getSecondOfMinute() / size * size).secondOfMinute().roundFloorCopy();
                    break;
                }
                case MINUTES: {
                    dateTime = dateTime.withMinuteOfHour(dateTime.getMinuteOfHour() / size * size).minuteOfHour().roundFloorCopy();
                    break;
                }
                case HOURS: {
                    dateTime = dateTime.withHourOfDay(dateTime.getHourOfDay() / size * size).hourOfDay().roundFloorCopy();
                    break;
                }
                case DAYS: {
                    dateTime = dateTime.withDayOfMonth((dateTime.getDayOfMonth() - 1) / size * size + 1).dayOfMonth().roundFloorCopy();
                    break;
                }
            }
            return outputFormatter.print((ReadableInstant)dateTime);
        }
        long granularityMs = this._granularitySpec.granularityToMillis();
        long roundedTimeValueMs = timeValueMs / granularityMs * granularityMs;
        if (this._outputFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.EPOCH) {
            return this._outputFormatSpec.getColumnUnit().convert(roundedTimeValueMs, TimeUnit.MILLISECONDS) / (long)this._outputFormatSpec.getColumnSize();
        }
        return this._outputFormatSpec.fromMillisToFormat(roundedTimeValueMs);
    }
}

