/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerQueryPhase;
import org.apache.pinot.common.metrics.BrokerTimer;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public class BrokerMetrics
extends AbstractMetrics<BrokerQueryPhase, BrokerMeter, BrokerGauge, BrokerTimer> {
    private static final AtomicReference<BrokerMetrics> BROKER_METRICS_INSTANCE = new AtomicReference();

    public static boolean register(BrokerMetrics brokerMetrics) {
        return BROKER_METRICS_INSTANCE.compareAndSet(null, brokerMetrics);
    }

    public static BrokerMetrics get() {
        BrokerMetrics ret = BROKER_METRICS_INSTANCE.get();
        assert (ret != null);
        return ret;
    }

    public BrokerMetrics(PinotMetricsRegistry metricsRegistry) {
        this(metricsRegistry, true, Collections.emptySet());
    }

    public BrokerMetrics(PinotMetricsRegistry metricsRegistry, boolean isTableLevelMetricsEnabled, Collection<String> allowedTables) {
        this("pinot.broker.", metricsRegistry, isTableLevelMetricsEnabled, allowedTables);
    }

    public BrokerMetrics(String prefix, PinotMetricsRegistry metricsRegistry, boolean isTableLevelMetricsEnabled, Collection<String> allowedTables) {
        super(prefix, metricsRegistry, BrokerMetrics.class, isTableLevelMetricsEnabled, allowedTables);
    }

    protected BrokerQueryPhase[] getQueryPhases() {
        return BrokerQueryPhase.values();
    }

    protected BrokerMeter[] getMeters() {
        return BrokerMeter.values();
    }

    protected BrokerGauge[] getGauges() {
        return BrokerGauge.values();
    }
}

