/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum ServerGauge implements AbstractMetrics.Gauge
{
    VERSION("version", true),
    DOCUMENT_COUNT("documents", false),
    SEGMENT_COUNT("segments", false),
    LLC_PARTITION_CONSUMING("state", false),
    HIGHEST_STREAM_OFFSET_CONSUMED("messages", false),
    LAST_REALTIME_SEGMENT_CREATION_DURATION_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_CREATION_WAIT_TIME_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_INITIAL_CONSUMPTION_DURATION_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_CATCHUP_DURATION_SECONDS("seconds", false),
    LAST_REALTIME_SEGMENT_COMPLETION_DURATION_SECONDS("seconds", false),
    REALTIME_OFFHEAP_MEMORY_USED("bytes", false),
    REALTIME_SEGMENT_NUM_PARTITIONS("realtimeSegmentNumPartitions", false),
    LLC_SIMULTANEOUS_SEGMENT_BUILDS("llcSimultaneousSegmentBuilds", true),
    UPSERT_PRIMARY_KEYS_COUNT("upsertPrimaryKeysCount", false),
    DEDUP_PRIMARY_KEYS_COUNT("dedupPrimaryKeysCount", false),
    CONSUMPTION_QUOTA_UTILIZATION("ratio", false),
    JVM_HEAP_USED_BYTES("bytes", true),
    NETTY_POOLED_USED_DIRECT_MEMORY("bytes", true),
    NETTY_POOLED_USED_HEAP_MEMORY("bytes", true),
    NETTY_POOLED_ARENAS_DIRECT("arenas", true),
    NETTY_POOLED_ARENAS_HEAP("arenas", true),
    NETTY_POOLED_CACHE_SIZE_SMALL("bytes", true),
    NETTY_POOLED_CACHE_SIZE_NORMAL("bytes", true),
    NETTY_POOLED_THREADLOCALCACHE("bytes", true),
    NETTY_POOLED_CHUNK_SIZE("bytes", true),
    REALTIME_INGESTION_DELAY_MS("milliseconds", false),
    END_TO_END_REALTIME_INGESTION_DELAY_MS("milliseconds", false),
    UPSERT_VALID_DOC_ID_SNAPSHOT_COUNT("upsertValidDocIdSnapshotCount", false),
    UPSERT_PRIMARY_KEYS_IN_SNAPSHOT_COUNT("upsertPrimaryKeysInSnapshotCount", false);

    private final String _gaugeName;
    private final String _unit;
    private final boolean _global;
    private final String _description;

    private ServerGauge(String unit, boolean global) {
        this(unit, global, "");
    }

    private ServerGauge(String unit, boolean global, String description) {
        this._unit = unit;
        this._global = global;
        this._gaugeName = Utils.toCamelCase(this.name().toLowerCase());
        this._description = description;
    }

    @Override
    public String getGaugeName() {
        return this._gaugeName;
    }

    @Override
    public String getUnit() {
        return this._unit;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

