/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public class ServerMetrics
extends AbstractMetrics<ServerQueryPhase, ServerMeter, ServerGauge, ServerTimer> {
    private static final AtomicReference<ServerMetrics> SERVER_METRICS_INSTANCE = new AtomicReference();

    public static boolean register(ServerMetrics serverMetrics) {
        return SERVER_METRICS_INSTANCE.compareAndSet(null, serverMetrics);
    }

    @VisibleForTesting
    public static void deregister() {
        SERVER_METRICS_INSTANCE.set(null);
    }

    public static ServerMetrics get() {
        ServerMetrics ret = SERVER_METRICS_INSTANCE.get();
        assert (ret != null);
        return ret;
    }

    public ServerMetrics(PinotMetricsRegistry metricsRegistry) {
        this("pinot.server.", metricsRegistry, true, Collections.emptySet());
    }

    public ServerMetrics(PinotMetricsRegistry metricsRegistry, boolean isTableLevelMetricsEnabled, Collection<String> allowedTables) {
        this("pinot.server.", metricsRegistry, isTableLevelMetricsEnabled, allowedTables);
    }

    public ServerMetrics(String prefix, PinotMetricsRegistry metricsRegistry, boolean isTableLevelMetricsEnabled, Collection<String> allowedTables) {
        super(prefix, metricsRegistry, ServerMetrics.class, isTableLevelMetricsEnabled, allowedTables);
    }

    protected ServerQueryPhase[] getQueryPhases() {
        return ServerQueryPhase.values();
    }

    protected ServerMeter[] getMeters() {
        return ServerMeter.values();
    }

    protected ServerGauge[] getGauges() {
        return ServerGauge.values();
    }
}

