/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response.broker;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.BrokerResponseStats;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonPropertyOrder(value={"resultTable", "requestId", "stageStats", "brokerId", "exceptions", "numServersQueried", "numServersResponded", "numSegmentsQueried", "numSegmentsProcessed", "numSegmentsMatched", "numConsumingSegmentsQueried", "numConsumingSegmentsProcessed", "numConsumingSegmentsMatched", "numDocsScanned", "numEntriesScannedInFilter", "numEntriesScannedPostFilter", "numGroupsLimitReached", "maxRowsInJoinReached", "totalDocs", "timeUsedMs", "offlineThreadCpuTimeNs", "realtimeThreadCpuTimeNs", "offlineSystemActivitiesCpuTimeNs", "realtimeSystemActivitiesCpuTimeNs", "offlineResponseSerializationCpuTimeNs", "realtimeResponseSerializationCpuTimeNs", "offlineTotalCpuTimeNs", "realtimeTotalCpuTimeNs", "brokerReduceTimeMs", "segmentStatistics", "traceInfo", "partialResult"})
public class BrokerResponseNativeV2
extends BrokerResponseNative {
    private final Map<Integer, BrokerResponseStats> _stageIdStats = new HashMap<Integer, BrokerResponseStats>();

    public BrokerResponseNativeV2() {
    }

    public BrokerResponseNativeV2(ProcessingException exception) {
        super(exception);
    }

    public BrokerResponseNativeV2(List<ProcessingException> exceptions) {
        super(exceptions);
    }

    private static BrokerResponseNativeV2 getBrokerResponseExplainPlanOutput() {
        BrokerResponseNativeV2 brokerResponse = BrokerResponseNativeV2.empty();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(new Object[]{"BROKER_EVALUATE", 0, -1});
        brokerResponse.setResultTable(new ResultTable(DataSchema.EXPLAIN_RESULT_SCHEMA, rows));
        return brokerResponse;
    }

    public static BrokerResponseNativeV2 empty() {
        return new BrokerResponseNativeV2();
    }

    public static BrokerResponseNativeV2 fromJsonString(String jsonString) throws IOException {
        return (BrokerResponseNativeV2)JsonUtils.stringToObject((String)jsonString, BrokerResponseNativeV2.class);
    }

    public void addStageStat(Integer stageId, BrokerResponseStats brokerResponseStats) {
        if (brokerResponseStats.getStageExecWallTimeMs() != -1L) {
            this._stageIdStats.put(stageId, brokerResponseStats);
        }
    }

    @JsonProperty(value="stageStats")
    public Map<Integer, BrokerResponseStats> getStageIdStats() {
        return this._stageIdStats;
    }
}

