/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class RoaringBitmapUtils {
    private RoaringBitmapUtils() {
    }

    public static byte[] serialize(ImmutableBitmapDataProvider bitmap) {
        byte[] bytes = new byte[bitmap.serializedSizeInBytes()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        bitmap.serialize(byteBuffer);
        return bytes;
    }

    public static RoaringBitmap deserialize(byte[] bytes) {
        return RoaringBitmapUtils.deserialize(ByteBuffer.wrap(bytes));
    }

    public static RoaringBitmap deserialize(ByteBuffer byteBuffer) {
        RoaringBitmap bitmap = new RoaringBitmap();
        try {
            bitmap.deserialize(byteBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Caught exception while deserializing RoaringBitmap", e);
        }
        return bitmap;
    }
}

