/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.RoundRobinURIProvider;
import org.apache.pinot.common.utils.fetcher.BaseSegmentFetcher;
import org.apache.pinot.common.utils.http.HttpClientConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.pinot.spi.utils.retry.RetryPolicies;

public class HttpSegmentFetcher
extends BaseSegmentFetcher {
    protected FileUploadDownloadClient _httpClient;

    @Override
    protected void doInit(PinotConfiguration config) {
        this._httpClient = new FileUploadDownloadClient(HttpClientConfig.newBuilder(config).build());
    }

    public HttpSegmentFetcher() {
    }

    @VisibleForTesting
    protected HttpSegmentFetcher(FileUploadDownloadClient httpClient, PinotConfiguration config) {
        this._httpClient = httpClient;
        this._retryCount = config.getProperty("retry.count", 3);
        this._retryWaitMs = config.getProperty("retry.wait.ms", 100);
        this._retryDelayScaleFactor = config.getProperty("retry.delay.scale.factor", 5);
        this._logger.info("Initialized with retryCount: {}, retryWaitMs: {}, retryDelayScaleFactor: {}", new Object[]{this._retryCount, this._retryWaitMs, this._retryDelayScaleFactor});
    }

    @Override
    public void fetchSegmentToLocal(URI downloadURI, File dest) throws Exception {
        RoundRobinURIProvider uriProvider = new RoundRobinURIProvider(downloadURI);
        int retryCount = this.getRetryCount(uriProvider);
        this._logger.info("Retry downloading for {} times. retryCount from pinot server config: {}, number of IP addresses for download URI: {}", new Object[]{retryCount, this._retryCount, uriProvider.numAddresses()});
        RetryPolicies.exponentialBackoffRetryPolicy((int)retryCount, (long)this._retryWaitMs, (double)this._retryDelayScaleFactor).attempt(() -> {
            URI uri = uriProvider.next();
            try {
                String hostName = downloadURI.getHost();
                int port = downloadURI.getPort();
                LinkedList<Header> httpHeaders = new LinkedList<Header>();
                if (!InetAddresses.isInetAddress((String)hostName)) {
                    httpHeaders.add((Header)new BasicHeader("Host", hostName + ":" + port));
                }
                int statusCode = this._httpClient.downloadFile(uri, dest, this._authProvider, httpHeaders);
                this._logger.info("Downloaded segment from: {} to: {} of size: {}; Response status code: {}", new Object[]{uri, dest, dest.length(), statusCode});
                return true;
            }
            catch (HttpErrorStatusException e) {
                int statusCode = e.getStatusCode();
                if (statusCode == 404 || statusCode >= 500) {
                    this._logger.warn("Got temporary error status code: {} while downloading segment from: {} to: {}", new Object[]{statusCode, uri, dest, e});
                    return false;
                }
                this._logger.error("Got permanent error status code: {} while downloading segment from: {} to: {}, won't retry", new Object[]{statusCode, uri, dest, e});
                throw e;
            }
            catch (Exception e) {
                this._logger.warn("Caught exception while downloading segment from: {} to: {}", new Object[]{uri, dest, e});
                return false;
            }
        });
    }

    private int getRetryCount(RoundRobinURIProvider uriProvider) {
        return Math.min(this._retryCount, uriProvider.numAddresses());
    }

    @Override
    public File fetchUntarSegmentToLocalStreamed(URI downloadURI, File dest, long maxStreamRateInByte, AtomicInteger attempts) throws Exception {
        int tries;
        RoundRobinURIProvider uriProvider = new RoundRobinURIProvider(downloadURI);
        int retryCount = this.getRetryCount(uriProvider);
        AtomicReference ret = new AtomicReference();
        this._logger.info("Retry downloading for {} times. retryCount from pinot server config: {}, number of IP addresses for download URI: {}", new Object[]{retryCount, this._retryCount, uriProvider.numAddresses()});
        try {
            tries = RetryPolicies.exponentialBackoffRetryPolicy((int)retryCount, (long)this._retryWaitMs, (double)this._retryDelayScaleFactor).attempt(() -> {
                URI uri = uriProvider.next();
                try {
                    String hostName = downloadURI.getHost();
                    int port = downloadURI.getPort();
                    LinkedList<Header> httpHeaders = new LinkedList<Header>();
                    if (!InetAddresses.isInetAddress((String)hostName)) {
                        httpHeaders.add((Header)new BasicHeader("Host", hostName + ":" + port));
                    }
                    ret.set(this._httpClient.downloadUntarFileStreamed(uri, dest, this._authProvider, httpHeaders, maxStreamRateInByte));
                    return true;
                }
                catch (HttpErrorStatusException e) {
                    int statusCode = e.getStatusCode();
                    if (statusCode == 404 || statusCode >= 500) {
                        this._logger.warn("Got temporary error status code: {} while downloading segment from: {} to: {}", new Object[]{statusCode, uri, dest, e});
                        return false;
                    }
                    this._logger.error("Got permanent error status code: {} while downloading segment from: {} to: {}, won't retry", new Object[]{statusCode, uri, dest, e});
                    throw e;
                }
                catch (IOException e) {
                    this._logger.warn("Caught IOException while stream download-untarring segment from: {} to: {}, retrying", new Object[]{uri, dest, e});
                    return false;
                }
                catch (Exception e) {
                    this._logger.warn("Caught exception while downloading segment from: {} to: {}", new Object[]{uri, dest, e});
                    return false;
                }
            });
        }
        catch (AttemptsExceededException e) {
            attempts.set(e.getAttempts());
            throw e;
        }
        catch (RetriableOperationException e) {
            attempts.set(e.getAttempts());
            throw e;
        }
        attempts.set(tries);
        return (File)ret.get();
    }

    @Override
    public void fetchSegmentToLocalWithoutRetry(URI uri, File dest) throws Exception {
        try {
            int statusCode = this._httpClient.downloadFile(uri, dest, this._authProvider);
            this._logger.info("Try to download the segment from: {} to: {} of size: {}; Response status code: {}", new Object[]{uri, dest, dest.length(), statusCode});
            if (statusCode >= 300) {
                throw new HttpErrorStatusException("Failed to download segment", statusCode);
            }
        }
        catch (Exception e) {
            this._logger.warn("Caught exception while downloading segment from: {} to: {}", new Object[]{uri, dest, e});
            throw e;
        }
    }
}

