/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import javax.annotation.Nonnull;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.segment.spi.memory.DataBuffer;

public class ColumnarDataBlock
extends BaseDataBlock {
    private static final int VERSION = 2;
    protected int[] _cumulativeColumnOffsetSizeInBytes;
    protected int[] _columnSizeInBytes;
    private int _fixDataSize;

    public ColumnarDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, DataBuffer fixedSizeDataBytes, DataBuffer variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    protected void computeBlockObjectConstants() {
        this._fixDataSize = 0;
        if (this._dataSchema != null) {
            this._cumulativeColumnOffsetSizeInBytes = new int[this._numColumns];
            this._columnSizeInBytes = new int[this._numColumns];
            DataBlockUtils.computeColumnSizeInBytes(this._dataSchema, this._columnSizeInBytes);
            int cumulativeColumnOffset = 0;
            for (int i = 0; i < this._numColumns; ++i) {
                this._cumulativeColumnOffsetSizeInBytes[i] = cumulativeColumnOffset;
                cumulativeColumnOffset += this._columnSizeInBytes[i] * this._numRows;
            }
            this._fixDataSize = cumulativeColumnOffset;
        }
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return this._cumulativeColumnOffsetSizeInBytes[colId] + this._columnSizeInBytes[colId] * rowId;
    }

    @Override
    public DataBlock.Type getDataBlockType() {
        return DataBlock.Type.COLUMNAR;
    }

    @Override
    protected int getFixDataSize() {
        return this._fixDataSize;
    }

    @Override
    @Nonnull
    public DataSchema getDataSchema() {
        return super.getDataSchema();
    }
}

