/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.segment.spi.memory.DataBuffer;

public interface DataBlockSerde {
    public DataBuffer serialize(DataBlock var1, int var2) throws IOException;

    public DataBlock deserialize(DataBuffer var1, long var2, DataBlock.Type var4, @Nullable LongConsumer var5) throws IOException;

    default public DataBlock deserialize(DataBuffer buffer, long offset, DataBlock.Type type) throws IOException {
        return this.deserialize(buffer, offset, type, null);
    }

    public Version getVersion();

    public static enum Version {
        V1_V2(2);

        private final int _version;

        private Version(int version) {
            this._version = version;
        }

        public static Version fromInt(int version) {
            switch (version) {
                case 1: 
                case 2: {
                    return V1_V2;
                }
            }
            throw new IllegalArgumentException("Unknown version: " + version);
        }

        public int getVersion() {
            return this._version;
        }
    }
}

