/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBlock
extends BaseDataBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataBlock.class);
    @VisibleForTesting
    static final int VERSION = 2;
    @Nullable
    private List<DataBuffer> _statsByStage;

    private MetadataBlock() {
        this(Collections.emptyList());
    }

    public static MetadataBlock newEos() {
        return new MetadataBlock();
    }

    public static MetadataBlock newError(Map<Integer, String> exceptions) {
        MetadataBlock errorBlock = new MetadataBlock();
        for (Map.Entry<Integer, String> exception : exceptions.entrySet()) {
            errorBlock.addException(exception.getKey(), exception.getValue());
        }
        return errorBlock;
    }

    public MetadataBlock(List<DataBuffer> statsByStage) {
        super(0, null, new String[0], new byte[0], new byte[0]);
        this._statsByStage = statsByStage;
    }

    public MetadataBlockType getType() {
        return this._errCodeToExceptionMap.isEmpty() ? MetadataBlockType.EOS : MetadataBlockType.ERROR;
    }

    @Override
    @Nullable
    public List<DataBuffer> getStatsByStage() {
        return this._statsByStage;
    }

    @Override
    public DataBlock.Type getDataBlockType() {
        return DataBlock.Type.METADATA;
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        throw new UnsupportedOperationException("Not supported in metadata block");
    }

    @Override
    protected int getFixDataSize() {
        return 0;
    }

    public static enum MetadataBlockType {
        EOS,
        ERROR;

    }
}

