/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class UrlFunctions {
    private UrlFunctions() {
    }

    @Nullable
    @ScalarFunction
    public static String urlProtocol(String url) {
        try {
            return URI.create(url).getScheme();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlDomain(String url) {
        try {
            return URI.create(url).getHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlDomainWithoutWWW(String url) {
        try {
            String domain = URI.create(url).getHost();
            if (domain != null && domain.startsWith("www.")) {
                return domain.substring(4);
            }
            return domain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlTopLevelDomain(String url) {
        try {
            String domain = URI.create(url).getHost();
            if (domain != null) {
                String[] domainParts = domain.split("\\.");
                return domainParts[domainParts.length - 1];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlFirstSignificantSubdomain(String url) {
        try {
            String domain = URI.create(url).getHost();
            if (domain != null) {
                String[] domainParts = domain.split("\\.");
                if (domainParts.length <= 2) {
                    return domainParts[0];
                }
                String tld = domainParts[domainParts.length - 1];
                if (tld.equals("com") || tld.equals("net") || tld.equals("org") || tld.equals("co")) {
                    return domainParts[domainParts.length - 2];
                }
                return domainParts[domainParts.length - 3];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String cutToFirstSignificantSubdomain(String url) {
        try {
            String domain = URI.create(url).getHost();
            if (domain != null) {
                String[] domainParts = domain.split("\\.");
                if (domainParts.length <= 2) {
                    return domain;
                }
                String tld = domainParts[domainParts.length - 1];
                if (tld.equals("com") || tld.equals("net") || tld.equals("org") || tld.equals("co")) {
                    return domainParts[domainParts.length - 2] + "." + domainParts[domainParts.length - 1];
                }
                return domainParts[domainParts.length - 3] + "." + domainParts[domainParts.length - 2] + "." + domainParts[domainParts.length - 1];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String cutToFirstSignificantSubdomainWithWWW(String url) {
        try {
            String domain = URI.create(url).getHost();
            if (domain != null) {
                String[] domainParts = domain.split("\\.");
                if (domainParts.length <= 2) {
                    return domain;
                }
                String tld = domainParts[domainParts.length - 1];
                if (tld.equals("com") || tld.equals("net") || tld.equals("org") || tld.equals("co")) {
                    String subDomain = domainParts[domainParts.length - 2] + "." + domainParts[domainParts.length - 1];
                    if (domainParts[0].equals("www") && domainParts.length == 3) {
                        return "www." + subDomain;
                    }
                    return subDomain;
                }
                String subDomain = domainParts[domainParts.length - 3] + "." + domainParts[domainParts.length - 2] + "." + domainParts[domainParts.length - 1];
                if (domainParts[0].equals("www") && domainParts.length == 4) {
                    return "www." + subDomain;
                }
                return subDomain;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScalarFunction
    public static int urlPort(String url) {
        try {
            return URI.create(url).getPort();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlPath(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getScheme() == null || uri.getHost() == null) {
                return null;
            }
            return uri.getPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlPathWithQuery(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getScheme() == null || uri.getHost() == null) {
                return null;
            }
            return URI.create(url).getRawPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlQueryString(String url) {
        try {
            if (url == null) {
                return null;
            }
            URI uri = new URI(url);
            return uri.getRawQuery();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlFragment(String url) {
        try {
            return URI.create(url).getFragment();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlQueryStringAndFragment(String url) {
        try {
            if (url == null) {
                return null;
            }
            URI uri = new URI(url);
            String query = uri.getQuery();
            String fragment = uri.getFragment();
            if (query == null && fragment == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            if (query != null) {
                result.append(query);
            }
            if (fragment != null) {
                if (result.length() > 0) {
                    result.append("#");
                }
                result.append(fragment);
            }
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScalarFunction
    public static String extractURLParameter(String url, String name) {
        try {
            if (url == null || name == null) {
                return "";
            }
            URI uri = new URI(url);
            String query = uri.getQuery();
            if (query == null) {
                return "";
            }
            for (String param : query.split("&")) {
                String[] keyValue = param.split("=", 2);
                if (!keyValue[0].equals(name)) continue;
                return keyValue.length > 1 ? keyValue[1] : "";
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @ScalarFunction
    public static String[] extractURLParameters(String url) {
        try {
            if (url == null) {
                return new String[0];
            }
            URI uri = new URI(url);
            String query = uri.getQuery();
            if (query == null) {
                return new String[0];
            }
            return query.split("&");
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @ScalarFunction
    public static String[] extractURLParameterNames(String url) {
        try {
            if (url == null) {
                return new String[0];
            }
            URI uri = new URI(url);
            String query = uri.getQuery();
            if (query == null) {
                return new String[0];
            }
            String[] params = query.split("&");
            String[] names = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                names[i] = params[i].split("=", 2)[0];
            }
            return names;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @ScalarFunction
    public static String[] urlHierarchy(String url) {
        try {
            if (url == null) {
                return new String[0];
            }
            URI uri = new URI(url);
            if (uri.getScheme() == null || uri.getHost() == null) {
                return new String[0];
            }
            String baseUrl = uri.getScheme() + "://" + uri.getHost();
            String path = uri.getPath();
            if (path == null || path.isEmpty()) {
                return new String[]{baseUrl};
            }
            String[] pathParts = path.split("/");
            String[] hierarchy = new String[pathParts.length];
            hierarchy[0] = baseUrl;
            StringBuilder currentPath = new StringBuilder(baseUrl);
            for (int i = 1; i < pathParts.length; ++i) {
                currentPath.append("/").append(pathParts[i]);
                hierarchy[i] = currentPath.toString();
            }
            return hierarchy;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @ScalarFunction
    public static String[] urlPathHierarchy(String url) {
        try {
            if (url == null) {
                return new String[0];
            }
            URI uri = new URI(url);
            String path = uri.getPath();
            if (path == null || path.isEmpty()) {
                return new String[0];
            }
            String[] pathParts = path.split("/");
            String[] hierarchy = new String[pathParts.length - 1];
            for (int i = 1; i < pathParts.length; ++i) {
                StringBuilder part = new StringBuilder();
                for (int j = 1; j <= i; ++j) {
                    part.append("/").append(pathParts[j]);
                }
                hierarchy[i - 1] = part.toString();
            }
            return hierarchy;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, StandardCharsets.UTF_8).replace("%20", "+");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlEncodeFormComponent(String url) {
        try {
            if (url == null) {
                return null;
            }
            return URLEncoder.encode(url, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlDecodeFormComponent(String url) {
        try {
            if (url == null) {
                return null;
            }
            return URLDecoder.decode(url.replace("+", "%20"), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction
    public static String urlNetloc(String url) {
        try {
            if (url == null) {
                return null;
            }
            URI uri = new URI(url);
            String userInfo = uri.getUserInfo();
            String host = uri.getHost();
            int port = uri.getPort();
            Object portStr = port == -1 ? "" : ":" + port;
            StringBuilder netloc = new StringBuilder();
            if (userInfo != null && !userInfo.isEmpty()) {
                netloc.append(userInfo).append("@");
            }
            if (host != null) {
                netloc.append(host);
            }
            netloc.append((String)portStr);
            return netloc.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @ScalarFunction
    public static String cutWWW(String url) {
        try {
            URI uri = new URI(url);
            String host = uri.getHost();
            if (host != null && host.startsWith("www.")) {
                host = host.substring(4);
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), host, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    @ScalarFunction
    public static String cutQueryString(String url) {
        try {
            URI uri = new URI(url);
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, uri.getFragment()).toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    @ScalarFunction
    public static String cutFragment(String url) {
        try {
            URI uri = new URI(url);
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    @ScalarFunction
    public static String cutQueryStringAndFragment(String url) {
        try {
            URI uri = new URI(url);
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null).toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    @ScalarFunction
    public static String cutURLParameter(String url, String name) {
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            if (query == null || query.isEmpty()) {
                return url;
            }
            StringBuilder newQuery = new StringBuilder();
            for (String param : query.split("&")) {
                String[] pair = param.split("=", 2);
                String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8);
                if (key.equals(name)) continue;
                if (newQuery.length() > 0) {
                    newQuery.append("&");
                }
                newQuery.append(pair[0]);
                if (pair.length <= 1) continue;
                newQuery.append("=").append(pair[1]);
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), newQuery.length() > 0 ? newQuery.toString() : null, uri.getFragment()).toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    @ScalarFunction
    public static String cutURLParameters(String url, String[] names) {
        for (String name : names) {
            url = UrlFunctions.cutURLParameter(url, name);
        }
        return url;
    }
}

