/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.scalar.comparison.PolymorphicComparisonScalarFunction;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.annotations.ScalarFunction;

@ScalarFunction
public class EqualsScalarFunction
extends PolymorphicComparisonScalarFunction {
    private static final Map<DataSchema.ColumnDataType, FunctionInfo> TYPE_FUNCTION_INFO_MAP = new EnumMap<DataSchema.ColumnDataType, FunctionInfo>(DataSchema.ColumnDataType.class);
    private static final FunctionInfo DOUBLE_EQUALS_WITH_TOLERANCE;

    @Override
    protected FunctionInfo functionInfoForType(DataSchema.ColumnDataType argumentType) {
        return TYPE_FUNCTION_INFO_MAP.get((Object)argumentType);
    }

    @Override
    protected FunctionInfo defaultFunctionInfo() {
        return DOUBLE_EQUALS_WITH_TOLERANCE;
    }

    @Override
    public String getName() {
        return "equals";
    }

    public static boolean intEquals(int a, int b) {
        return a == b;
    }

    public static boolean longEquals(long a, long b) {
        return a == b;
    }

    public static boolean floatEquals(float a, float b) {
        return a == b;
    }

    public static boolean doubleEquals(double a, double b) {
        return a == b;
    }

    public static boolean doubleEqualsWithTolerance(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    public static boolean bigDecimalEquals(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) == 0;
    }

    public static boolean stringEquals(String a, String b) {
        return a.equals(b);
    }

    public static boolean bytesEquals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean objectEquals(Object a, Object b) {
        return Objects.equals(a, b);
    }

    public static boolean intArrayEquals(int[] a, int[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean longArrayEquals(long[] a, long[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean floatArrayEquals(float[] a, float[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean doubleArrayEquals(double[] a, double[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean stringArrayEquals(String[] a, String[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean bytesArrayEquals(byte[][] a, byte[][] b) {
        return Arrays.deepEquals((Object[])a, (Object[])b);
    }

    static {
        try {
            DOUBLE_EQUALS_WITH_TOLERANCE = new FunctionInfo(EqualsScalarFunction.class.getMethod("doubleEqualsWithTolerance", Double.TYPE, Double.TYPE), EqualsScalarFunction.class, false);
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT, new FunctionInfo(EqualsScalarFunction.class.getMethod("intEquals", Integer.TYPE, Integer.TYPE), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG, new FunctionInfo(EqualsScalarFunction.class.getMethod("longEquals", Long.TYPE, Long.TYPE), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT, new FunctionInfo(EqualsScalarFunction.class.getMethod("floatEquals", Float.TYPE, Float.TYPE), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE, new FunctionInfo(EqualsScalarFunction.class.getMethod("doubleEquals", Double.TYPE, Double.TYPE), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BIG_DECIMAL, new FunctionInfo(EqualsScalarFunction.class.getMethod("bigDecimalEquals", BigDecimal.class, BigDecimal.class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING, new FunctionInfo(EqualsScalarFunction.class.getMethod("stringEquals", String.class, String.class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BYTES, new FunctionInfo(EqualsScalarFunction.class.getMethod("bytesEquals", byte[].class, byte[].class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.OBJECT, new FunctionInfo(EqualsScalarFunction.class.getMethod("objectEquals", Object.class, Object.class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.INT_ARRAY, new FunctionInfo(EqualsScalarFunction.class.getMethod("intArrayEquals", int[].class, int[].class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.LONG_ARRAY, new FunctionInfo(EqualsScalarFunction.class.getMethod("longArrayEquals", long[].class, long[].class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.FLOAT_ARRAY, new FunctionInfo(EqualsScalarFunction.class.getMethod("floatArrayEquals", float[].class, float[].class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.DOUBLE_ARRAY, new FunctionInfo(EqualsScalarFunction.class.getMethod("doubleArrayEquals", double[].class, double[].class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.STRING_ARRAY, new FunctionInfo(EqualsScalarFunction.class.getMethod("stringArrayEquals", String[].class, String[].class), EqualsScalarFunction.class, false));
            TYPE_FUNCTION_INFO_MAP.put(DataSchema.ColumnDataType.BYTES_ARRAY, new FunctionInfo(EqualsScalarFunction.class.getMethod("bytesArrayEquals", byte[][].class, byte[][].class), EqualsScalarFunction.class, false));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

