/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar.comparison;

import javax.annotation.Nullable;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.PinotScalarFunction;
import org.apache.pinot.common.utils.DataSchema;

public abstract class PolymorphicComparisonScalarFunction
implements PinotScalarFunction {
    protected static final double DOUBLE_COMPARISON_TOLERANCE = 1.0E-7;

    @Override
    @Nullable
    public FunctionInfo getFunctionInfo(DataSchema.ColumnDataType[] argumentTypes) {
        if (argumentTypes.length != 2) {
            return null;
        }
        if (argumentTypes[0].getStoredType() != argumentTypes[1].getStoredType()) {
            return this.defaultFunctionInfo();
        }
        return this.functionInfoForType(argumentTypes[0].getStoredType());
    }

    @Override
    @Nullable
    public FunctionInfo getFunctionInfo(int numArguments) {
        if (numArguments != 2) {
            return null;
        }
        return this.defaultFunctionInfo();
    }

    protected abstract FunctionInfo functionInfoForType(DataSchema.ColumnDataType var1);

    protected FunctionInfo defaultFunctionInfo() {
        return this.functionInfoForType(DataSchema.ColumnDataType.DOUBLE);
    }
}

