/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ApplicationQpsQuotaRefreshMessage
extends Message {
    public static final String REFRESH_APP_QUOTA_MSG_SUB_TYPE = "REFRESH_APPLICATION_QUOTA";
    private static final String APPLICATION_NAME_KEY = "applicationName";

    public ApplicationQpsQuotaRefreshMessage(String applicationName) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(REFRESH_APP_QUOTA_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(APPLICATION_NAME_KEY, applicationName);
    }

    public ApplicationQpsQuotaRefreshMessage(Message message) {
        super(message.getRecord());
        if (!message.getMsgSubType().equals(REFRESH_APP_QUOTA_MSG_SUB_TYPE)) {
            throw new IllegalArgumentException("Invalid message subtype:" + message.getMsgSubType());
        }
    }

    public String getApplicationName() {
        return this.getRecord().getSimpleField(APPLICATION_NAME_KEY);
    }
}

