/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum BrokerGauge implements AbstractMetrics.Gauge
{
    VERSION("version", true),
    QUERY_QUOTA_CAPACITY_UTILIZATION_RATE("tables", false),
    MAX_BURST_QPS("tables", false),
    QUERY_RATE_LIMIT_DISABLED("queryQuota", true),
    NETTY_CONNECTION_CONNECT_TIME_MS("nettyConnection", true),
    REQUEST_SIZE("requestSize", false),
    RESIZE_TIME_MS("milliseconds", false),
    UNHEALTHY_SERVERS("servers", true),
    TIME_BOUNDARY_DIFFERENCE("milliseconds", false),
    JVM_HEAP_USED_BYTES("bytes", true),
    NETTY_POOLED_USED_DIRECT_MEMORY("bytes", true),
    NETTY_POOLED_USED_HEAP_MEMORY("bytes", true),
    NETTY_POOLED_ARENAS_DIRECT("arenas", true),
    NETTY_POOLED_ARENAS_HEAP("arenas", true),
    NETTY_POOLED_CACHE_SIZE_SMALL("bytes", true),
    NETTY_POOLED_CACHE_SIZE_NORMAL("bytes", true),
    NETTY_POOLED_THREADLOCALCACHE("bytes", true),
    NETTY_POOLED_CHUNK_SIZE("bytes", true),
    ADAPTIVE_SERVER_SELECTOR_TYPE("adaptiveServerSelectorType", true),
    ROUTING_STATS_MANAGER_QUEUE_SIZE("routingStatsManagerQueueSize", true);

    private final String _brokerGaugeName;
    private final String _unit;
    private final boolean _global;

    private BrokerGauge(String unit, boolean global) {
        this._unit = unit;
        this._global = global;
        this._brokerGaugeName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getGaugeName() {
        return this._brokerGaugeName;
    }

    @Override
    public String getUnit() {
        return this._unit;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }
}

