/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.helix.AccessOption;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.StringUtil;
import org.apache.zookeeper.data.Stat;

public final class MinionTaskMetadataUtils {
    private MinionTaskMetadataUtils() {
    }

    @Nullable
    public static ZNRecord fetchTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        String newPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(tableNameWithType, taskType);
        if (propertyStore.exists(newPath, AccessOption.PERSISTENT)) {
            return MinionTaskMetadataUtils.fetchTaskMetadata(propertyStore, newPath);
        }
        return MinionTaskMetadataUtils.fetchTaskMetadata(propertyStore, ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(taskType, tableNameWithType));
    }

    @Nullable
    private static ZNRecord fetchTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String path) {
        Stat stat = new Stat();
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat, AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    public static Map<String, Map<String, Long>> getAllTaskMetadataLastUpdateTimeMs(HelixPropertyStore<ZNRecord> propertyStore) {
        HashMap<String, Map<String, Long>> tableTaskLastUpdateTimeMsMap = new HashMap<String, Map<String, Long>>();
        String propertyStorePathForMinionTaskMetadataPrefix = ZKMetadataProvider.getPropertyStorePathForMinionTaskMetadataPrefix();
        List tableNameWithTypeOrTaskTypes = propertyStore.getChildNames(propertyStorePathForMinionTaskMetadataPrefix, AccessOption.PERSISTENT);
        if (tableNameWithTypeOrTaskTypes == null || tableNameWithTypeOrTaskTypes.isEmpty()) {
            return tableTaskLastUpdateTimeMsMap;
        }
        for (String tableNameWithTypeOrTaskType : tableNameWithTypeOrTaskTypes) {
            String metadataNodeDirectParentPath = StringUtil.join((String)"/", (String[])new String[]{propertyStorePathForMinionTaskMetadataPrefix, tableNameWithTypeOrTaskType});
            List metadataNodeNames = propertyStore.getChildNames(metadataNodeDirectParentPath, AccessOption.PERSISTENT);
            if (metadataNodeNames == null || metadataNodeNames.isEmpty()) continue;
            boolean isNewPath = tableNameWithTypeOrTaskType.endsWith(TableType.OFFLINE.toString()) || tableNameWithTypeOrTaskType.endsWith(TableType.REALTIME.toString());
            for (String metadataNodeName : metadataNodeNames) {
                String metadataNodePath = StringUtil.join((String)"/", (String[])new String[]{metadataNodeDirectParentPath, metadataNodeName});
                Stat stat = propertyStore.getStat(metadataNodePath, AccessOption.PERSISTENT);
                if (isNewPath) {
                    MinionTaskMetadataUtils.saveOrUpdateTaskMetadataLastUpdateTime(tableNameWithTypeOrTaskType, metadataNodeName, stat.getMtime(), tableTaskLastUpdateTimeMsMap);
                    continue;
                }
                MinionTaskMetadataUtils.saveOrUpdateTaskMetadataLastUpdateTime(metadataNodeName, tableNameWithTypeOrTaskType, stat.getMtime(), tableTaskLastUpdateTimeMsMap);
            }
        }
        return tableTaskLastUpdateTimeMsMap;
    }

    private static void saveOrUpdateTaskMetadataLastUpdateTime(String tableNameWithType, String taskType, long newLastUpdateTimeMs, Map<String, Map<String, Long>> tableTaskLastUpdateTimeMsMap) {
        tableTaskLastUpdateTimeMsMap.computeIfAbsent(tableNameWithType, tnt -> new HashMap()).compute(taskType, (tt, lastUpdateTimeMs) -> {
            if (lastUpdateTimeMs == null) {
                return newLastUpdateTimeMs;
            }
            return Math.max(lastUpdateTimeMs, newLastUpdateTimeMs);
        });
    }

    public static void deleteTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, String tableNameWithType) {
        String newPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(tableNameWithType, taskType);
        String oldPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(taskType, tableNameWithType);
        boolean newPathDeleted = propertyStore.remove(newPath, AccessOption.PERSISTENT);
        boolean oldPathDeleted = propertyStore.remove(oldPath, AccessOption.PERSISTENT);
        if (!newPathDeleted || !oldPathDeleted) {
            throw new ZkException("Failed to delete task metadata: " + taskType + ", " + tableNameWithType);
        }
    }

    public static void deleteTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        String path = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(tableNameWithType);
        if (!propertyStore.remove(path, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to delete task metadata for table: " + tableNameWithType);
        }
        List childNames = propertyStore.getChildNames(ZKMetadataProvider.getPropertyStorePathForMinionTaskMetadataPrefix(), AccessOption.PERSISTENT);
        if (childNames != null && !childNames.isEmpty()) {
            for (String child : childNames) {
                String oldPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(child, tableNameWithType);
                if (propertyStore.remove(oldPath, AccessOption.PERSISTENT)) continue;
                throw new ZkException("Failed to delete task metadata: " + child + ", " + tableNameWithType);
            }
        }
    }

    public static void persistTaskMetadata(HelixPropertyStore<ZNRecord> propertyStore, String taskType, BaseTaskMetadata taskMetadata, int expectedVersion) {
        String newPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadata(taskMetadata.getTableNameWithType(), taskType);
        String oldPath = ZKMetadataProvider.constructPropertyStorePathForMinionTaskMetadataDeprecated(taskType, taskMetadata.getTableNameWithType());
        if (propertyStore.exists(newPath, AccessOption.PERSISTENT) || !propertyStore.exists(oldPath, AccessOption.PERSISTENT)) {
            MinionTaskMetadataUtils.persistTaskMetadata(newPath, propertyStore, taskType, taskMetadata, expectedVersion);
        } else {
            MinionTaskMetadataUtils.persistTaskMetadata(oldPath, propertyStore, taskType, taskMetadata, expectedVersion);
        }
    }

    private static void persistTaskMetadata(String path, HelixPropertyStore<ZNRecord> propertyStore, String taskType, BaseTaskMetadata taskMetadata, int expectedVersion) {
        if (!propertyStore.set(path, (Object)taskMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT)) {
            throw new ZkException("Failed to persist minion metadata for task: " + taskType + " and metadata: " + taskMetadata);
        }
    }
}

