/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class Literal
extends TUnion<Literal, _Fields> {
    private static final TStruct STRUCT_DESC = new TStruct("Literal");
    private static final TField BOOL_VALUE_FIELD_DESC = new TField("boolValue", 2, 1);
    private static final TField BYTE_VALUE_FIELD_DESC = new TField("byteValue", 3, 2);
    private static final TField SHORT_VALUE_FIELD_DESC = new TField("shortValue", 6, 3);
    private static final TField INT_VALUE_FIELD_DESC = new TField("intValue", 8, 4);
    private static final TField LONG_VALUE_FIELD_DESC = new TField("longValue", 10, 5);
    private static final TField DOUBLE_VALUE_FIELD_DESC = new TField("doubleValue", 4, 6);
    private static final TField STRING_VALUE_FIELD_DESC = new TField("stringValue", 11, 7);
    private static final TField BINARY_VALUE_FIELD_DESC = new TField("binaryValue", 11, 8);
    private static final TField NULL_VALUE_FIELD_DESC = new TField("nullValue", 2, 9);
    private static final TField BIG_DECIMAL_VALUE_FIELD_DESC = new TField("bigDecimalValue", 11, 10);
    private static final TField FLOAT_VALUE_FIELD_DESC = new TField("floatValue", 8, 11);
    private static final TField INT_ARRAY_VALUE_FIELD_DESC = new TField("intArrayValue", 15, 12);
    private static final TField LONG_ARRAY_VALUE_FIELD_DESC = new TField("longArrayValue", 15, 13);
    private static final TField FLOAT_ARRAY_VALUE_FIELD_DESC = new TField("floatArrayValue", 15, 14);
    private static final TField DOUBLE_ARRAY_VALUE_FIELD_DESC = new TField("doubleArrayValue", 15, 15);
    private static final TField STRING_ARRAY_VALUE_FIELD_DESC = new TField("stringArrayValue", 15, 16);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Literal() {
    }

    public Literal(_Fields setField, Object value) {
        super((TFieldIdEnum)setField, value);
    }

    public Literal(Literal other) {
        super((TUnion)other);
    }

    public Literal deepCopy() {
        return new Literal(this);
    }

    public static Literal boolValue(boolean value) {
        Literal x = new Literal();
        x.setBoolValue(value);
        return x;
    }

    public static Literal byteValue(byte value) {
        Literal x = new Literal();
        x.setByteValue(value);
        return x;
    }

    public static Literal shortValue(short value) {
        Literal x = new Literal();
        x.setShortValue(value);
        return x;
    }

    public static Literal intValue(int value) {
        Literal x = new Literal();
        x.setIntValue(value);
        return x;
    }

    public static Literal longValue(long value) {
        Literal x = new Literal();
        x.setLongValue(value);
        return x;
    }

    public static Literal doubleValue(double value) {
        Literal x = new Literal();
        x.setDoubleValue(value);
        return x;
    }

    public static Literal stringValue(String value) {
        Literal x = new Literal();
        x.setStringValue(value);
        return x;
    }

    public static Literal binaryValue(ByteBuffer value) {
        Literal x = new Literal();
        x.setBinaryValue(value);
        return x;
    }

    public static Literal binaryValue(byte[] value) {
        Literal x = new Literal();
        x.setBinaryValue(ByteBuffer.wrap((byte[])value.clone()));
        return x;
    }

    public static Literal nullValue(boolean value) {
        Literal x = new Literal();
        x.setNullValue(value);
        return x;
    }

    public static Literal bigDecimalValue(ByteBuffer value) {
        Literal x = new Literal();
        x.setBigDecimalValue(value);
        return x;
    }

    public static Literal bigDecimalValue(byte[] value) {
        Literal x = new Literal();
        x.setBigDecimalValue(ByteBuffer.wrap((byte[])value.clone()));
        return x;
    }

    public static Literal floatValue(int value) {
        Literal x = new Literal();
        x.setFloatValue(value);
        return x;
    }

    public static Literal intArrayValue(List<Integer> value) {
        Literal x = new Literal();
        x.setIntArrayValue(value);
        return x;
    }

    public static Literal longArrayValue(List<Long> value) {
        Literal x = new Literal();
        x.setLongArrayValue(value);
        return x;
    }

    public static Literal floatArrayValue(List<Integer> value) {
        Literal x = new Literal();
        x.setFloatArrayValue(value);
        return x;
    }

    public static Literal doubleArrayValue(List<Double> value) {
        Literal x = new Literal();
        x.setDoubleArrayValue(value);
        return x;
    }

    public static Literal stringArrayValue(List<String> value) {
        Literal x = new Literal();
        x.setStringArrayValue(value);
        return x;
    }

    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case BOOL_VALUE: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type java.lang.Boolean for field 'boolValue', but got " + value.getClass().getSimpleName());
            }
            case BYTE_VALUE: {
                if (value instanceof Byte) break;
                throw new ClassCastException("Was expecting value of type java.lang.Byte for field 'byteValue', but got " + value.getClass().getSimpleName());
            }
            case SHORT_VALUE: {
                if (value instanceof Short) break;
                throw new ClassCastException("Was expecting value of type java.lang.Short for field 'shortValue', but got " + value.getClass().getSimpleName());
            }
            case INT_VALUE: {
                if (value instanceof Integer) break;
                throw new ClassCastException("Was expecting value of type java.lang.Integer for field 'intValue', but got " + value.getClass().getSimpleName());
            }
            case LONG_VALUE: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type java.lang.Long for field 'longValue', but got " + value.getClass().getSimpleName());
            }
            case DOUBLE_VALUE: {
                if (value instanceof Double) break;
                throw new ClassCastException("Was expecting value of type java.lang.Double for field 'doubleValue', but got " + value.getClass().getSimpleName());
            }
            case STRING_VALUE: {
                if (value instanceof String) break;
                throw new ClassCastException("Was expecting value of type java.lang.String for field 'stringValue', but got " + value.getClass().getSimpleName());
            }
            case BINARY_VALUE: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type java.nio.ByteBuffer for field 'binaryValue', but got " + value.getClass().getSimpleName());
            }
            case NULL_VALUE: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type java.lang.Boolean for field 'nullValue', but got " + value.getClass().getSimpleName());
            }
            case BIG_DECIMAL_VALUE: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type java.nio.ByteBuffer for field 'bigDecimalValue', but got " + value.getClass().getSimpleName());
            }
            case FLOAT_VALUE: {
                if (value instanceof Integer) break;
                throw new ClassCastException("Was expecting value of type java.lang.Integer for field 'floatValue', but got " + value.getClass().getSimpleName());
            }
            case INT_ARRAY_VALUE: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type java.util.List<java.lang.Integer> for field 'intArrayValue', but got " + value.getClass().getSimpleName());
            }
            case LONG_ARRAY_VALUE: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type java.util.List<java.lang.Long> for field 'longArrayValue', but got " + value.getClass().getSimpleName());
            }
            case FLOAT_ARRAY_VALUE: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type java.util.List<java.lang.Integer> for field 'floatArrayValue', but got " + value.getClass().getSimpleName());
            }
            case DOUBLE_ARRAY_VALUE: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type java.util.List<java.lang.Double> for field 'doubleArrayValue', but got " + value.getClass().getSimpleName());
            }
            case STRING_ARRAY_VALUE: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type java.util.List<java.lang.String> for field 'stringArrayValue', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + setField);
            }
        }
    }

    protected Object standardSchemeReadValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case BOOL_VALUE: {
                    if (field.type == Literal.BOOL_VALUE_FIELD_DESC.type) {
                        Boolean boolValue = iprot.readBool();
                        return boolValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BYTE_VALUE: {
                    if (field.type == Literal.BYTE_VALUE_FIELD_DESC.type) {
                        Byte byteValue = iprot.readByte();
                        return byteValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case SHORT_VALUE: {
                    if (field.type == Literal.SHORT_VALUE_FIELD_DESC.type) {
                        Short shortValue = iprot.readI16();
                        return shortValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case INT_VALUE: {
                    if (field.type == Literal.INT_VALUE_FIELD_DESC.type) {
                        Integer intValue = iprot.readI32();
                        return intValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case LONG_VALUE: {
                    if (field.type == Literal.LONG_VALUE_FIELD_DESC.type) {
                        Long longValue = iprot.readI64();
                        return longValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case DOUBLE_VALUE: {
                    if (field.type == Literal.DOUBLE_VALUE_FIELD_DESC.type) {
                        Double doubleValue = iprot.readDouble();
                        return doubleValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case STRING_VALUE: {
                    if (field.type == Literal.STRING_VALUE_FIELD_DESC.type) {
                        String stringValue = iprot.readString();
                        return stringValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BINARY_VALUE: {
                    if (field.type == Literal.BINARY_VALUE_FIELD_DESC.type) {
                        ByteBuffer binaryValue = iprot.readBinary();
                        return binaryValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case NULL_VALUE: {
                    if (field.type == Literal.NULL_VALUE_FIELD_DESC.type) {
                        Boolean nullValue = iprot.readBool();
                        return nullValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BIG_DECIMAL_VALUE: {
                    if (field.type == Literal.BIG_DECIMAL_VALUE_FIELD_DESC.type) {
                        ByteBuffer bigDecimalValue = iprot.readBinary();
                        return bigDecimalValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case FLOAT_VALUE: {
                    if (field.type == Literal.FLOAT_VALUE_FIELD_DESC.type) {
                        Integer floatValue = iprot.readI32();
                        return floatValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case INT_ARRAY_VALUE: {
                    if (field.type == Literal.INT_ARRAY_VALUE_FIELD_DESC.type) {
                        TList _list44 = iprot.readListBegin();
                        ArrayList<Integer> intArrayValue = new ArrayList<Integer>(_list44.size);
                        for (int _i46 = 0; _i46 < _list44.size; ++_i46) {
                            int _elem45 = iprot.readI32();
                            intArrayValue.add(_elem45);
                        }
                        iprot.readListEnd();
                        return intArrayValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case LONG_ARRAY_VALUE: {
                    if (field.type == Literal.LONG_ARRAY_VALUE_FIELD_DESC.type) {
                        TList _list47 = iprot.readListBegin();
                        ArrayList<Long> longArrayValue = new ArrayList<Long>(_list47.size);
                        for (int _i49 = 0; _i49 < _list47.size; ++_i49) {
                            long _elem48 = iprot.readI64();
                            longArrayValue.add(_elem48);
                        }
                        iprot.readListEnd();
                        return longArrayValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case FLOAT_ARRAY_VALUE: {
                    if (field.type == Literal.FLOAT_ARRAY_VALUE_FIELD_DESC.type) {
                        TList _list50 = iprot.readListBegin();
                        ArrayList<Integer> floatArrayValue = new ArrayList<Integer>(_list50.size);
                        for (int _i52 = 0; _i52 < _list50.size; ++_i52) {
                            int _elem51 = iprot.readI32();
                            floatArrayValue.add(_elem51);
                        }
                        iprot.readListEnd();
                        return floatArrayValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case DOUBLE_ARRAY_VALUE: {
                    if (field.type == Literal.DOUBLE_ARRAY_VALUE_FIELD_DESC.type) {
                        TList _list53 = iprot.readListBegin();
                        ArrayList<Double> doubleArrayValue = new ArrayList<Double>(_list53.size);
                        for (int _i55 = 0; _i55 < _list53.size; ++_i55) {
                            double _elem54 = iprot.readDouble();
                            doubleArrayValue.add(_elem54);
                        }
                        iprot.readListEnd();
                        return doubleArrayValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case STRING_ARRAY_VALUE: {
                    if (field.type == Literal.STRING_ARRAY_VALUE_FIELD_DESC.type) {
                        TList _list56 = iprot.readListBegin();
                        ArrayList<String> stringArrayValue = new ArrayList<String>(_list56.size);
                        for (int _i58 = 0; _i58 < _list56.size; ++_i58) {
                            String _elem57 = iprot.readString();
                            stringArrayValue.add(_elem57);
                        }
                        iprot.readListEnd();
                        return stringArrayValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
        return null;
    }

    protected void standardSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case BOOL_VALUE: {
                Boolean boolValue = (Boolean)this.value_;
                oprot.writeBool(boolValue.booleanValue());
                return;
            }
            case BYTE_VALUE: {
                Byte byteValue = (Byte)this.value_;
                oprot.writeByte(byteValue.byteValue());
                return;
            }
            case SHORT_VALUE: {
                Short shortValue = (Short)this.value_;
                oprot.writeI16(shortValue.shortValue());
                return;
            }
            case INT_VALUE: {
                Integer intValue = (Integer)this.value_;
                oprot.writeI32(intValue.intValue());
                return;
            }
            case LONG_VALUE: {
                Long longValue = (Long)this.value_;
                oprot.writeI64(longValue.longValue());
                return;
            }
            case DOUBLE_VALUE: {
                Double doubleValue = (Double)this.value_;
                oprot.writeDouble(doubleValue.doubleValue());
                return;
            }
            case STRING_VALUE: {
                String stringValue = (String)this.value_;
                oprot.writeString(stringValue);
                return;
            }
            case BINARY_VALUE: {
                ByteBuffer binaryValue = (ByteBuffer)this.value_;
                oprot.writeBinary(binaryValue);
                return;
            }
            case NULL_VALUE: {
                Boolean nullValue = (Boolean)this.value_;
                oprot.writeBool(nullValue.booleanValue());
                return;
            }
            case BIG_DECIMAL_VALUE: {
                ByteBuffer bigDecimalValue = (ByteBuffer)this.value_;
                oprot.writeBinary(bigDecimalValue);
                return;
            }
            case FLOAT_VALUE: {
                Integer floatValue = (Integer)this.value_;
                oprot.writeI32(floatValue.intValue());
                return;
            }
            case INT_ARRAY_VALUE: {
                List intArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(8, intArrayValue.size()));
                Iterator iterator = intArrayValue.iterator();
                while (iterator.hasNext()) {
                    int _iter59 = (Integer)iterator.next();
                    oprot.writeI32(_iter59);
                }
                oprot.writeListEnd();
                return;
            }
            case LONG_ARRAY_VALUE: {
                List longArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(10, longArrayValue.size()));
                Iterator _iter59 = longArrayValue.iterator();
                while (_iter59.hasNext()) {
                    long _iter60 = (Long)_iter59.next();
                    oprot.writeI64(_iter60);
                }
                oprot.writeListEnd();
                return;
            }
            case FLOAT_ARRAY_VALUE: {
                List floatArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(8, floatArrayValue.size()));
                Iterator _iter60 = floatArrayValue.iterator();
                while (_iter60.hasNext()) {
                    int _iter61 = (Integer)_iter60.next();
                    oprot.writeI32(_iter61);
                }
                oprot.writeListEnd();
                return;
            }
            case DOUBLE_ARRAY_VALUE: {
                List doubleArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(4, doubleArrayValue.size()));
                Iterator _iter61 = doubleArrayValue.iterator();
                while (_iter61.hasNext()) {
                    double _iter62 = (Double)_iter61.next();
                    oprot.writeDouble(_iter62);
                }
                oprot.writeListEnd();
                return;
            }
            case STRING_ARRAY_VALUE: {
                List stringArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(11, stringArrayValue.size()));
                for (String _iter63 : stringArrayValue) {
                    oprot.writeString(_iter63);
                }
                oprot.writeListEnd();
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    protected Object tupleSchemeReadValue(TProtocol iprot, short fieldID) throws TException {
        _Fields setField = _Fields.findByThriftId(fieldID);
        if (setField != null) {
            switch (setField) {
                case BOOL_VALUE: {
                    Boolean boolValue = iprot.readBool();
                    return boolValue;
                }
                case BYTE_VALUE: {
                    Byte byteValue = iprot.readByte();
                    return byteValue;
                }
                case SHORT_VALUE: {
                    Short shortValue = iprot.readI16();
                    return shortValue;
                }
                case INT_VALUE: {
                    Integer intValue = iprot.readI32();
                    return intValue;
                }
                case LONG_VALUE: {
                    Long longValue = iprot.readI64();
                    return longValue;
                }
                case DOUBLE_VALUE: {
                    Double doubleValue = iprot.readDouble();
                    return doubleValue;
                }
                case STRING_VALUE: {
                    String stringValue = iprot.readString();
                    return stringValue;
                }
                case BINARY_VALUE: {
                    ByteBuffer binaryValue = iprot.readBinary();
                    return binaryValue;
                }
                case NULL_VALUE: {
                    Boolean nullValue = iprot.readBool();
                    return nullValue;
                }
                case BIG_DECIMAL_VALUE: {
                    ByteBuffer bigDecimalValue = iprot.readBinary();
                    return bigDecimalValue;
                }
                case FLOAT_VALUE: {
                    Integer floatValue = iprot.readI32();
                    return floatValue;
                }
                case INT_ARRAY_VALUE: {
                    TList _list64 = iprot.readListBegin();
                    ArrayList<Integer> intArrayValue = new ArrayList<Integer>(_list64.size);
                    for (int _i66 = 0; _i66 < _list64.size; ++_i66) {
                        int _elem65 = iprot.readI32();
                        intArrayValue.add(_elem65);
                    }
                    iprot.readListEnd();
                    return intArrayValue;
                }
                case LONG_ARRAY_VALUE: {
                    TList _list67 = iprot.readListBegin();
                    ArrayList<Long> longArrayValue = new ArrayList<Long>(_list67.size);
                    for (int _i69 = 0; _i69 < _list67.size; ++_i69) {
                        long _elem68 = iprot.readI64();
                        longArrayValue.add(_elem68);
                    }
                    iprot.readListEnd();
                    return longArrayValue;
                }
                case FLOAT_ARRAY_VALUE: {
                    TList _list70 = iprot.readListBegin();
                    ArrayList<Integer> floatArrayValue = new ArrayList<Integer>(_list70.size);
                    for (int _i72 = 0; _i72 < _list70.size; ++_i72) {
                        int _elem71 = iprot.readI32();
                        floatArrayValue.add(_elem71);
                    }
                    iprot.readListEnd();
                    return floatArrayValue;
                }
                case DOUBLE_ARRAY_VALUE: {
                    TList _list73 = iprot.readListBegin();
                    ArrayList<Double> doubleArrayValue = new ArrayList<Double>(_list73.size);
                    for (int _i75 = 0; _i75 < _list73.size; ++_i75) {
                        double _elem74 = iprot.readDouble();
                        doubleArrayValue.add(_elem74);
                    }
                    iprot.readListEnd();
                    return doubleArrayValue;
                }
                case STRING_ARRAY_VALUE: {
                    TList _list76 = iprot.readListBegin();
                    ArrayList<String> stringArrayValue = new ArrayList<String>(_list76.size);
                    for (int _i78 = 0; _i78 < _list76.size; ++_i78) {
                        String _elem77 = iprot.readString();
                        stringArrayValue.add(_elem77);
                    }
                    iprot.readListEnd();
                    return stringArrayValue;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        throw new TProtocolException("Couldn't find a field with field id " + fieldID);
    }

    protected void tupleSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case BOOL_VALUE: {
                Boolean boolValue = (Boolean)this.value_;
                oprot.writeBool(boolValue.booleanValue());
                return;
            }
            case BYTE_VALUE: {
                Byte byteValue = (Byte)this.value_;
                oprot.writeByte(byteValue.byteValue());
                return;
            }
            case SHORT_VALUE: {
                Short shortValue = (Short)this.value_;
                oprot.writeI16(shortValue.shortValue());
                return;
            }
            case INT_VALUE: {
                Integer intValue = (Integer)this.value_;
                oprot.writeI32(intValue.intValue());
                return;
            }
            case LONG_VALUE: {
                Long longValue = (Long)this.value_;
                oprot.writeI64(longValue.longValue());
                return;
            }
            case DOUBLE_VALUE: {
                Double doubleValue = (Double)this.value_;
                oprot.writeDouble(doubleValue.doubleValue());
                return;
            }
            case STRING_VALUE: {
                String stringValue = (String)this.value_;
                oprot.writeString(stringValue);
                return;
            }
            case BINARY_VALUE: {
                ByteBuffer binaryValue = (ByteBuffer)this.value_;
                oprot.writeBinary(binaryValue);
                return;
            }
            case NULL_VALUE: {
                Boolean nullValue = (Boolean)this.value_;
                oprot.writeBool(nullValue.booleanValue());
                return;
            }
            case BIG_DECIMAL_VALUE: {
                ByteBuffer bigDecimalValue = (ByteBuffer)this.value_;
                oprot.writeBinary(bigDecimalValue);
                return;
            }
            case FLOAT_VALUE: {
                Integer floatValue = (Integer)this.value_;
                oprot.writeI32(floatValue.intValue());
                return;
            }
            case INT_ARRAY_VALUE: {
                List intArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(8, intArrayValue.size()));
                Iterator iterator = intArrayValue.iterator();
                while (iterator.hasNext()) {
                    int _iter79 = (Integer)iterator.next();
                    oprot.writeI32(_iter79);
                }
                oprot.writeListEnd();
                return;
            }
            case LONG_ARRAY_VALUE: {
                List longArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(10, longArrayValue.size()));
                Iterator _iter79 = longArrayValue.iterator();
                while (_iter79.hasNext()) {
                    long _iter80 = (Long)_iter79.next();
                    oprot.writeI64(_iter80);
                }
                oprot.writeListEnd();
                return;
            }
            case FLOAT_ARRAY_VALUE: {
                List floatArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(8, floatArrayValue.size()));
                Iterator _iter80 = floatArrayValue.iterator();
                while (_iter80.hasNext()) {
                    int _iter81 = (Integer)_iter80.next();
                    oprot.writeI32(_iter81);
                }
                oprot.writeListEnd();
                return;
            }
            case DOUBLE_ARRAY_VALUE: {
                List doubleArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(4, doubleArrayValue.size()));
                Iterator _iter81 = doubleArrayValue.iterator();
                while (_iter81.hasNext()) {
                    double _iter82 = (Double)_iter81.next();
                    oprot.writeDouble(_iter82);
                }
                oprot.writeListEnd();
                return;
            }
            case STRING_ARRAY_VALUE: {
                List stringArrayValue = (List)this.value_;
                oprot.writeListBegin(new TList(11, stringArrayValue.size()));
                for (String _iter83 : stringArrayValue) {
                    oprot.writeString(_iter83);
                }
                oprot.writeListEnd();
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case BOOL_VALUE: {
                return BOOL_VALUE_FIELD_DESC;
            }
            case BYTE_VALUE: {
                return BYTE_VALUE_FIELD_DESC;
            }
            case SHORT_VALUE: {
                return SHORT_VALUE_FIELD_DESC;
            }
            case INT_VALUE: {
                return INT_VALUE_FIELD_DESC;
            }
            case LONG_VALUE: {
                return LONG_VALUE_FIELD_DESC;
            }
            case DOUBLE_VALUE: {
                return DOUBLE_VALUE_FIELD_DESC;
            }
            case STRING_VALUE: {
                return STRING_VALUE_FIELD_DESC;
            }
            case BINARY_VALUE: {
                return BINARY_VALUE_FIELD_DESC;
            }
            case NULL_VALUE: {
                return NULL_VALUE_FIELD_DESC;
            }
            case BIG_DECIMAL_VALUE: {
                return BIG_DECIMAL_VALUE_FIELD_DESC;
            }
            case FLOAT_VALUE: {
                return FLOAT_VALUE_FIELD_DESC;
            }
            case INT_ARRAY_VALUE: {
                return INT_ARRAY_VALUE_FIELD_DESC;
            }
            case LONG_ARRAY_VALUE: {
                return LONG_ARRAY_VALUE_FIELD_DESC;
            }
            case FLOAT_ARRAY_VALUE: {
                return FLOAT_ARRAY_VALUE_FIELD_DESC;
            }
            case DOUBLE_ARRAY_VALUE: {
                return DOUBLE_ARRAY_VALUE_FIELD_DESC;
            }
            case STRING_ARRAY_VALUE: {
                return STRING_ARRAY_VALUE_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + setField);
    }

    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public boolean getBoolValue() {
        if (this.getSetField() == _Fields.BOOL_VALUE) {
            return (Boolean)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'boolValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBoolValue(boolean value) {
        this.setField_ = _Fields.BOOL_VALUE;
        this.value_ = value;
    }

    public byte getByteValue() {
        if (this.getSetField() == _Fields.BYTE_VALUE) {
            return (Byte)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'byteValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setByteValue(byte value) {
        this.setField_ = _Fields.BYTE_VALUE;
        this.value_ = value;
    }

    public short getShortValue() {
        if (this.getSetField() == _Fields.SHORT_VALUE) {
            return (Short)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'shortValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setShortValue(short value) {
        this.setField_ = _Fields.SHORT_VALUE;
        this.value_ = value;
    }

    public int getIntValue() {
        if (this.getSetField() == _Fields.INT_VALUE) {
            return (Integer)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'intValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setIntValue(int value) {
        this.setField_ = _Fields.INT_VALUE;
        this.value_ = value;
    }

    public long getLongValue() {
        if (this.getSetField() == _Fields.LONG_VALUE) {
            return (Long)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'longValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setLongValue(long value) {
        this.setField_ = _Fields.LONG_VALUE;
        this.value_ = value;
    }

    public double getDoubleValue() {
        if (this.getSetField() == _Fields.DOUBLE_VALUE) {
            return (Double)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'doubleValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setDoubleValue(double value) {
        this.setField_ = _Fields.DOUBLE_VALUE;
        this.value_ = value;
    }

    public String getStringValue() {
        if (this.getSetField() == _Fields.STRING_VALUE) {
            return (String)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'stringValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setStringValue(String value) {
        this.setField_ = _Fields.STRING_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.STRING_VALUE");
    }

    public byte[] getBinaryValue() {
        this.setBinaryValue(TBaseHelper.rightSize((ByteBuffer)this.bufferForBinaryValue()));
        ByteBuffer b = this.bufferForBinaryValue();
        return b == null ? null : b.array();
    }

    public ByteBuffer bufferForBinaryValue() {
        if (this.getSetField() == _Fields.BINARY_VALUE) {
            return TBaseHelper.copyBinary((ByteBuffer)((ByteBuffer)this.getFieldValue()));
        }
        throw new RuntimeException("Cannot get field 'binaryValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBinaryValue(byte[] value) {
        this.setBinaryValue(ByteBuffer.wrap((byte[])value.clone()));
    }

    public void setBinaryValue(ByteBuffer value) {
        this.setField_ = _Fields.BINARY_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.BINARY_VALUE");
    }

    public boolean getNullValue() {
        if (this.getSetField() == _Fields.NULL_VALUE) {
            return (Boolean)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'nullValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setNullValue(boolean value) {
        this.setField_ = _Fields.NULL_VALUE;
        this.value_ = value;
    }

    public byte[] getBigDecimalValue() {
        this.setBigDecimalValue(TBaseHelper.rightSize((ByteBuffer)this.bufferForBigDecimalValue()));
        ByteBuffer b = this.bufferForBigDecimalValue();
        return b == null ? null : b.array();
    }

    public ByteBuffer bufferForBigDecimalValue() {
        if (this.getSetField() == _Fields.BIG_DECIMAL_VALUE) {
            return TBaseHelper.copyBinary((ByteBuffer)((ByteBuffer)this.getFieldValue()));
        }
        throw new RuntimeException("Cannot get field 'bigDecimalValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBigDecimalValue(byte[] value) {
        this.setBigDecimalValue(ByteBuffer.wrap((byte[])value.clone()));
    }

    public void setBigDecimalValue(ByteBuffer value) {
        this.setField_ = _Fields.BIG_DECIMAL_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.BIG_DECIMAL_VALUE");
    }

    public int getFloatValue() {
        if (this.getSetField() == _Fields.FLOAT_VALUE) {
            return (Integer)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'floatValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setFloatValue(int value) {
        this.setField_ = _Fields.FLOAT_VALUE;
        this.value_ = value;
    }

    public List<Integer> getIntArrayValue() {
        if (this.getSetField() == _Fields.INT_ARRAY_VALUE) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'intArrayValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setIntArrayValue(List<Integer> value) {
        this.setField_ = _Fields.INT_ARRAY_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.INT_ARRAY_VALUE");
    }

    public List<Long> getLongArrayValue() {
        if (this.getSetField() == _Fields.LONG_ARRAY_VALUE) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'longArrayValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setLongArrayValue(List<Long> value) {
        this.setField_ = _Fields.LONG_ARRAY_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.LONG_ARRAY_VALUE");
    }

    public List<Integer> getFloatArrayValue() {
        if (this.getSetField() == _Fields.FLOAT_ARRAY_VALUE) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'floatArrayValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setFloatArrayValue(List<Integer> value) {
        this.setField_ = _Fields.FLOAT_ARRAY_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.FLOAT_ARRAY_VALUE");
    }

    public List<Double> getDoubleArrayValue() {
        if (this.getSetField() == _Fields.DOUBLE_ARRAY_VALUE) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'doubleArrayValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setDoubleArrayValue(List<Double> value) {
        this.setField_ = _Fields.DOUBLE_ARRAY_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.DOUBLE_ARRAY_VALUE");
    }

    public List<String> getStringArrayValue() {
        if (this.getSetField() == _Fields.STRING_ARRAY_VALUE) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'stringArrayValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setStringArrayValue(List<String> value) {
        this.setField_ = _Fields.STRING_ARRAY_VALUE;
        this.value_ = Objects.requireNonNull(value, "_Fields.STRING_ARRAY_VALUE");
    }

    public boolean isSetBoolValue() {
        return this.setField_ == _Fields.BOOL_VALUE;
    }

    public boolean isSetByteValue() {
        return this.setField_ == _Fields.BYTE_VALUE;
    }

    public boolean isSetShortValue() {
        return this.setField_ == _Fields.SHORT_VALUE;
    }

    public boolean isSetIntValue() {
        return this.setField_ == _Fields.INT_VALUE;
    }

    public boolean isSetLongValue() {
        return this.setField_ == _Fields.LONG_VALUE;
    }

    public boolean isSetDoubleValue() {
        return this.setField_ == _Fields.DOUBLE_VALUE;
    }

    public boolean isSetStringValue() {
        return this.setField_ == _Fields.STRING_VALUE;
    }

    public boolean isSetBinaryValue() {
        return this.setField_ == _Fields.BINARY_VALUE;
    }

    public boolean isSetNullValue() {
        return this.setField_ == _Fields.NULL_VALUE;
    }

    public boolean isSetBigDecimalValue() {
        return this.setField_ == _Fields.BIG_DECIMAL_VALUE;
    }

    public boolean isSetFloatValue() {
        return this.setField_ == _Fields.FLOAT_VALUE;
    }

    public boolean isSetIntArrayValue() {
        return this.setField_ == _Fields.INT_ARRAY_VALUE;
    }

    public boolean isSetLongArrayValue() {
        return this.setField_ == _Fields.LONG_ARRAY_VALUE;
    }

    public boolean isSetFloatArrayValue() {
        return this.setField_ == _Fields.FLOAT_ARRAY_VALUE;
    }

    public boolean isSetDoubleArrayValue() {
        return this.setField_ == _Fields.DOUBLE_ARRAY_VALUE;
    }

    public boolean isSetStringArrayValue() {
        return this.setField_ == _Fields.STRING_ARRAY_VALUE;
    }

    public boolean equals(Object other) {
        if (other instanceof Literal) {
            return this.equals((Literal)((Object)other));
        }
        return false;
    }

    public boolean equals(Literal other) {
        return other != null && this.getSetField() == other.getSetField() && this.getFieldValue().equals(other.getFieldValue());
    }

    public int compareTo(Literal other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)((Comparable)this.getSetField()), (Comparable)((Comparable)other.getSetField()));
        if (lastComparison == 0) {
            return TBaseHelper.compareTo((Object)this.getFieldValue(), (Object)other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((Object)((Object)this)).getClass().getName());
        TFieldIdEnum setField = this.getSetField();
        if (setField != null) {
            list.add(setField.getThriftFieldId());
            Object value = this.getFieldValue();
            if (value instanceof TEnum) {
                list.add(((TEnum)this.getFieldValue()).getValue());
            } else {
                list.add(value);
            }
        }
        return list.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.BOOL_VALUE, new FieldMetaData("boolValue", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.BYTE_VALUE, new FieldMetaData("byteValue", 2, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.SHORT_VALUE, new FieldMetaData("shortValue", 2, new FieldValueMetaData(6)));
        tmpMap.put(_Fields.INT_VALUE, new FieldMetaData("intValue", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LONG_VALUE, new FieldMetaData("longValue", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DOUBLE_VALUE, new FieldMetaData("doubleValue", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.STRING_VALUE, new FieldMetaData("stringValue", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.BINARY_VALUE, new FieldMetaData("binaryValue", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.NULL_VALUE, new FieldMetaData("nullValue", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.BIG_DECIMAL_VALUE, new FieldMetaData("bigDecimalValue", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.FLOAT_VALUE, new FieldMetaData("floatValue", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.INT_ARRAY_VALUE, new FieldMetaData("intArrayValue", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.LONG_ARRAY_VALUE, new FieldMetaData("longArrayValue", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(10))));
        tmpMap.put(_Fields.FLOAT_ARRAY_VALUE, new FieldMetaData("floatArrayValue", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.DOUBLE_ARRAY_VALUE, new FieldMetaData("doubleArrayValue", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(4))));
        tmpMap.put(_Fields.STRING_ARRAY_VALUE, new FieldMetaData("stringArrayValue", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Literal.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        BOOL_VALUE(1, "boolValue"),
        BYTE_VALUE(2, "byteValue"),
        SHORT_VALUE(3, "shortValue"),
        INT_VALUE(4, "intValue"),
        LONG_VALUE(5, "longValue"),
        DOUBLE_VALUE(6, "doubleValue"),
        STRING_VALUE(7, "stringValue"),
        BINARY_VALUE(8, "binaryValue"),
        NULL_VALUE(9, "nullValue"),
        BIG_DECIMAL_VALUE(10, "bigDecimalValue"),
        FLOAT_VALUE(11, "floatValue"),
        INT_ARRAY_VALUE(12, "intArrayValue"),
        LONG_ARRAY_VALUE(13, "longArrayValue"),
        FLOAT_ARRAY_VALUE(14, "floatArrayValue"),
        DOUBLE_ARRAY_VALUE(15, "doubleArrayValue"),
        STRING_ARRAY_VALUE(16, "stringArrayValue");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return BOOL_VALUE;
                }
                case 2: {
                    return BYTE_VALUE;
                }
                case 3: {
                    return SHORT_VALUE;
                }
                case 4: {
                    return INT_VALUE;
                }
                case 5: {
                    return LONG_VALUE;
                }
                case 6: {
                    return DOUBLE_VALUE;
                }
                case 7: {
                    return STRING_VALUE;
                }
                case 8: {
                    return BINARY_VALUE;
                }
                case 9: {
                    return NULL_VALUE;
                }
                case 10: {
                    return BIG_DECIMAL_VALUE;
                }
                case 11: {
                    return FLOAT_VALUE;
                }
                case 12: {
                    return INT_ARRAY_VALUE;
                }
                case 13: {
                    return LONG_ARRAY_VALUE;
                }
                case 14: {
                    return FLOAT_ARRAY_VALUE;
                }
                case 15: {
                    return DOUBLE_ARRAY_VALUE;
                }
                case 16: {
                    return STRING_ARRAY_VALUE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

