/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context.predicate;

import java.util.Arrays;
import java.util.Objects;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.BasePredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;

public class VectorSimilarityPredicate
extends BasePredicate {
    public static final int DEFAULT_TOP_K = 10;
    private final float[] _value;
    private final int _topK;

    public VectorSimilarityPredicate(ExpressionContext lhs, float[] value, int topK) {
        super(lhs);
        this._value = value;
        this._topK = topK;
    }

    @Override
    public Predicate.Type getType() {
        return Predicate.Type.VECTOR_SIMILARITY;
    }

    public float[] getValue() {
        return this._value;
    }

    public int getTopK() {
        return this._topK;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorSimilarityPredicate)) {
            return false;
        }
        VectorSimilarityPredicate that = (VectorSimilarityPredicate)o;
        return Objects.equals(this._lhs, that._lhs) && Arrays.equals(this._value, that._value) && this._topK == that._topK;
    }

    public int hashCode() {
        return Objects.hash(this._lhs, Arrays.hashCode(this._value), this._topK);
    }

    public String toString() {
        return "vector_similarity(" + this._lhs + ",'" + Arrays.toString(this._value) + "'," + this._topK + ")";
    }
}

