/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.primitives.Chars;

public class RegexpPatternConverterUtils {
    public static final char[] REGEXP_METACHARACTERS = new char[]{'^', '$', '.', '{', '}', '[', ']', '(', ')', '*', '+', '?', '|', '<', '>', '-', '&', '/'};
    public static final char BACK_SLASH = '\\';

    private RegexpPatternConverterUtils() {
    }

    public static String likeToRegexpLike(String likePattern) {
        int start = 0;
        int end = likePattern.length();
        String prefix = "^";
        String suffix = "$";
        switch (likePattern.length()) {
            case 0: {
                return "^$";
            }
            case 1: {
                if (likePattern.charAt(0) != '%') break;
                return "";
            }
            default: {
                if (likePattern.charAt(0) == '%') {
                    start = RegexpPatternConverterUtils.indexOfFirstDifferent(likePattern, '%');
                    if (start == -1) {
                        return "";
                    }
                    prefix = "";
                }
                if (likePattern.charAt(likePattern.length() - 1) != '%') break;
                end = RegexpPatternConverterUtils.indexOfLastDifferent(likePattern, '%');
                if (end == -1) {
                    return "";
                }
                ++end;
                suffix = "";
            }
        }
        likePattern = likePattern.substring(start, end);
        return RegexpPatternConverterUtils.escapeMetaCharsAndWildcards(likePattern, prefix, suffix);
    }

    private static String escapeMetaCharsAndWildcards(String input, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        int len = input.length();
        boolean isPrevCharBackSlash = false;
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '_': {
                    sb.append(isPrevCharBackSlash ? Character.valueOf(c) : ".");
                    break;
                }
                case '%': {
                    sb.append(isPrevCharBackSlash ? Character.valueOf(c) : ".*");
                    break;
                }
                default: {
                    if (Chars.indexOf((char[])REGEXP_METACHARACTERS, (char)c) >= 0 || isPrevCharBackSlash) {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
            }
            isPrevCharBackSlash = c == '\\';
        }
        if (isPrevCharBackSlash) {
            sb.append('\\');
        }
        sb.append(suffix);
        return sb.toString();
    }

    private static int indexOfFirstDifferent(String str, char character) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == character) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfLastDifferent(String str, char character) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == character) continue;
            return i;
        }
        return -1;
    }

    public static String regexpLikeToLuceneRegExp(String regexpLikePattern) {
        if (((String)regexpLikePattern).isEmpty()) {
            return regexpLikePattern;
        }
        regexpLikePattern = ((String)regexpLikePattern).charAt(0) == '^' ? ((String)regexpLikePattern).substring(1) : ".*" + (String)regexpLikePattern;
        int length = ((String)regexpLikePattern).length();
        regexpLikePattern = ((String)regexpLikePattern).charAt(length - 1) == '$' ? ((String)regexpLikePattern).substring(0, length - 1) : (String)regexpLikePattern + ".*";
        return regexpLikePattern;
    }
}

