/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUtils.class);
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().build();

    private SchemaUtils() {
    }

    public static Schema fromZNRecord(@Nonnull ZNRecord record) throws IOException {
        String schemaJSON = record.getSimpleField("schemaJSON");
        return Schema.fromString((String)schemaJSON);
    }

    public static ZNRecord toZNRecord(@Nonnull Schema schema) {
        ZNRecord record = new ZNRecord(schema.getSchemaName());
        record.setSimpleField("schemaJSON", schema.toSingleLineJsonString());
        return record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Schema getSchema(@Nonnull String host, int port, @Nonnull String schemaName) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)schemaName);
        try {
            URL url = new URL("http", host, port, "/schemas/" + schemaName);
            HttpGet httpGet = new HttpGet(url.toString());
            try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpGet);){
                int responseCode = response.getCode();
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responseCode >= 400) {
                    if (responseCode == 404) {
                        LOGGER.info("Cannot find schema: {} from host: {}, port: {}", new Object[]{schemaName, host, port});
                    } else {
                        LOGGER.warn("Got error response code: {}, response: {}", (Object)responseCode, (Object)response);
                    }
                    Schema schema2 = null;
                    return schema2;
                }
                Schema schema = Schema.fromString((String)responseString);
                return schema;
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting the schema: {} from host: {}, port: {}", new Object[]{schemaName, host, port, e});
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean postSchema(@Nonnull String host, int port, @Nonnull Schema schema) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)schema);
        try {
            URL url = new URL("http", host, port, "/schemas");
            HttpPost httpPost = new HttpPost(url.toString());
            HttpEntity requestEntity = MultipartEntityBuilder.create().addTextBody(schema.getSchemaName(), schema.toSingleLineJsonString()).build();
            httpPost.setEntity(requestEntity);
            try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpPost);){
                int responseCode = response.getCode();
                if (responseCode >= 400) {
                    String responseString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
                    LOGGER.warn("Got error response code: {}, response: {}", (Object)responseCode, (Object)responseString);
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while posting the schema: {} to host: {}, port: {}", new Object[]{schema.getSchemaName(), host, port, e});
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteSchema(@Nonnull String host, int port, @Nonnull String schemaName) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull((Object)schemaName);
        try {
            URL url = new URL("http", host, port, "/schemas/" + schemaName);
            HttpDelete httpDelete = new HttpDelete(url.toString());
            try (CloseableHttpResponse response = HTTP_CLIENT.execute((ClassicHttpRequest)httpDelete);){
                int responseCode = response.getCode();
                if (responseCode >= 400) {
                    String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                    LOGGER.warn("Got error response code: {}, response: {}", (Object)responseCode, (Object)responseString);
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting the schema: {} from host: {}, port: {}", new Object[]{schemaName, host, port, e});
            return false;
        }
    }

    public static boolean equalsIgnoreVersion(@Nonnull Schema schema1, @Nonnull Schema schema2) {
        Preconditions.checkNotNull((Object)schema1);
        Preconditions.checkNotNull((Object)schema2);
        return schema1.getSchemaName().equals(schema2.getSchemaName()) && schema1.getFieldSpecMap().equals(schema2.getFieldSpecMap());
    }

    public static void main(String[] args) {
        Schema schema = new Schema.SchemaBuilder().setSchemaName("testSchema").addSingleValueDimension("dimension", FieldSpec.DataType.DOUBLE).addMetric("metric", FieldSpec.DataType.INT).addTime(new TimeGranularitySpec(FieldSpec.DataType.INT, TimeUnit.DAYS, "time"), null).build();
        System.out.println(SchemaUtils.postSchema("localhost", 8100, schema));
        Schema fetchedSchema = SchemaUtils.getSchema("localhost", 8100, "testSchema");
        Preconditions.checkNotNull((Object)fetchedSchema);
        System.out.println(fetchedSchema);
        System.out.println(SchemaUtils.equalsIgnoreVersion(schema, fetchedSchema));
        System.out.println(SchemaUtils.deleteSchema("localhost", 8100, "testSchema"));
    }
}

