/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.UploadedRealtimeSegmentName;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;

public class SegmentUtils {
    private SegmentUtils() {
    }

    @Nullable
    public static Integer getRealtimeSegmentPartitionId(String segmentName, String realtimeTableName, HelixManager helixManager, @Nullable String partitionColumn) {
        Integer partitionId = SegmentUtils.getPartitionIdFromRealtimeSegmentName(segmentName);
        if (partitionId != null) {
            return partitionId;
        }
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore<ZNRecord>)helixManager.getHelixPropertyStore(), realtimeTableName, segmentName);
        Preconditions.checkState((segmentZKMetadata != null ? 1 : 0) != 0, (String)"Failed to find segment ZK metadata for segment: %s of table: %s", (Object)segmentName, (Object)realtimeTableName);
        return SegmentUtils.getRealtimeSegmentPartitionId(segmentZKMetadata, partitionColumn);
    }

    @Nullable
    public static Integer getRealtimeSegmentPartitionId(String segmentName, SegmentZKMetadata segmentZKMetadata, @Nullable String partitionColumn) {
        Integer partitionId = SegmentUtils.getPartitionIdFromRealtimeSegmentName(segmentName);
        if (partitionId != null) {
            return partitionId;
        }
        return SegmentUtils.getRealtimeSegmentPartitionId(segmentZKMetadata, partitionColumn);
    }

    @Nullable
    public static Integer getPartitionIdFromRealtimeSegmentName(String segmentName) {
        LLCSegmentName llcSegmentName = LLCSegmentName.of(segmentName);
        if (llcSegmentName != null) {
            return llcSegmentName.getPartitionGroupId();
        }
        UploadedRealtimeSegmentName uploadedRealtimeSegmentName = UploadedRealtimeSegmentName.of(segmentName);
        if (uploadedRealtimeSegmentName != null) {
            return uploadedRealtimeSegmentName.getPartitionId();
        }
        return null;
    }

    @Nullable
    private static Integer getRealtimeSegmentPartitionId(SegmentZKMetadata segmentZKMetadata, @Nullable String partitionColumn) {
        SegmentPartitionMetadata segmentPartitionMetadata = segmentZKMetadata.getPartitionMetadata();
        if (segmentPartitionMetadata != null) {
            Map<String, ColumnPartitionMetadata> columnPartitionMap = segmentPartitionMetadata.getColumnPartitionMap();
            ColumnPartitionMetadata columnPartitionMetadata = null;
            if (partitionColumn != null) {
                columnPartitionMetadata = columnPartitionMap.get(partitionColumn);
            } else if (columnPartitionMap.size() == 1) {
                columnPartitionMetadata = columnPartitionMap.values().iterator().next();
            }
            if (columnPartitionMetadata != null && columnPartitionMetadata.getPartitions().size() == 1) {
                return (Integer)columnPartitionMetadata.getPartitions().iterator().next();
            }
        }
        return null;
    }

    public static long getSegmentCreationTimeMs(SegmentZKMetadata segmentZKMetadata) {
        long pushTimeMs = segmentZKMetadata.getPushTime();
        if (pushTimeMs > 0L) {
            return pushTimeMs;
        }
        return segmentZKMetadata.getCreationTime();
    }
}

