/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

public class Timer {
    private final long _timeoutMillis;
    private final long _startTime;

    public Timer(long timeoutMillis) {
        this._timeoutMillis = timeoutMillis;
        this._startTime = System.currentTimeMillis();
    }

    public long getRemainingTime() {
        long elapsedTime = System.currentTimeMillis() - this._startTime;
        long remainingTime = this._timeoutMillis - elapsedTime;
        return Math.max(remainingTime, 0L);
    }

    public boolean hasExpired() {
        return this.getRemainingTime() == 0L;
    }
}

