/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import org.apache.hc.core5.net.URIBuilder;

public class URIUtils {
    private URIUtils() {
    }

    public static URI getUri(String path) {
        try {
            URI uri = new URI(path);
            if (uri.getScheme() != null) {
                return uri;
            }
            return new URI("file:" + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal URI path: " + path, e);
        }
    }

    public static URI getUri(String basePath, String ... parts) {
        return URIUtils.getUri(URIUtils.getPath(basePath, parts));
    }

    public static String getPath(String basePath, String ... parts) {
        StringJoiner stringJoiner = new StringJoiner(File.separator);
        stringJoiner.add(basePath);
        for (String part : parts) {
            stringJoiner.add(part);
        }
        return stringJoiner.toString();
    }

    public static String getLastPart(String path) {
        if (path == null) {
            return null;
        }
        int parameterIndex = path.indexOf("?");
        path = parameterIndex >= 0 ? path.substring(0, parameterIndex) : path;
        return path.substring(path.lastIndexOf(File.separator) + 1);
    }

    public static String constructDownloadUrl(String baseUrl, String rawTableName, String segmentName) {
        return URIUtils.getPath(baseUrl, "segments", rawTableName, URIUtils.encode(segmentName));
    }

    public static String encode(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public static String decode(String string) {
        return URLDecoder.decode(string, StandardCharsets.UTF_8);
    }

    public static URI buildURI(String schema, String hostPort, String path, Map<String, String> params) {
        StringTokenizer tokenizer = new StringTokenizer(hostPort, ":");
        String host = tokenizer.nextToken();
        String port = null;
        if (tokenizer.hasMoreTokens()) {
            port = tokenizer.nextToken();
        }
        URIBuilder uriBuilder = new URIBuilder().setScheme(schema).setHost(host).setPath(path);
        if (port != null) {
            uriBuilder.setPort(Integer.parseInt(port));
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            return uriBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static URI buildURI(String schema, String host, int port, String path, Map<String, String> params) {
        return URIUtils.buildURI(schema, String.format("%s:%d", host, port), path, params);
    }
}

