/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.spi.config.table.DedupConfig;
import org.apache.pinot.spi.config.table.DimensionTableConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.QueryConfig;
import org.apache.pinot.spi.config.table.QuotaConfig;
import org.apache.pinot.spi.config.table.ReplicaGroupStrategyConfig;
import org.apache.pinot.spi.config.table.RoutingConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableCustomConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.TierConfig;
import org.apache.pinot.spi.config.table.TunerConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.config.table.assignment.SegmentAssignmentConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.StreamIngestionConfig;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableConfigUtils.class);
    private static final String FIELD_MISSING_MESSAGE_TEMPLATE = "Mandatory field '%s' is missing";

    private TableConfigUtils() {
    }

    public static TableConfig fromZNRecord(ZNRecord znRecord) throws IOException {
        Map simpleFields = znRecord.getSimpleFields();
        String tableName = znRecord.getId();
        String tableType = (String)simpleFields.get("tableType");
        boolean isDimTable = Boolean.parseBoolean((String)simpleFields.get("isDimTable"));
        Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"tableType");
        String validationConfigString = (String)simpleFields.get("segmentsConfig");
        Preconditions.checkState((validationConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"segmentsConfig");
        SegmentsValidationAndRetentionConfig validationConfig = (SegmentsValidationAndRetentionConfig)JsonUtils.stringToObject((String)validationConfigString, SegmentsValidationAndRetentionConfig.class);
        String tenantConfigString = (String)simpleFields.get("tenants");
        Preconditions.checkState((tenantConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"tenants");
        TenantConfig tenantConfig = (TenantConfig)JsonUtils.stringToObject((String)tenantConfigString, TenantConfig.class);
        String indexingConfigString = (String)simpleFields.get("tableIndexConfig");
        Preconditions.checkState((indexingConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"tableIndexConfig");
        IndexingConfig indexingConfig = (IndexingConfig)JsonUtils.stringToObject((String)indexingConfigString, IndexingConfig.class);
        String customConfigString = (String)simpleFields.get("metadata");
        Preconditions.checkState((customConfigString != null ? 1 : 0) != 0, (String)FIELD_MISSING_MESSAGE_TEMPLATE, (Object)"metadata");
        TableCustomConfig customConfig = (TableCustomConfig)JsonUtils.stringToObject((String)customConfigString, TableCustomConfig.class);
        QuotaConfig quotaConfig = null;
        String quotaConfigString = (String)simpleFields.get("quota");
        if (quotaConfigString != null) {
            quotaConfig = (QuotaConfig)JsonUtils.stringToObject((String)quotaConfigString, QuotaConfig.class);
        }
        TableTaskConfig taskConfig = null;
        String taskConfigString = (String)simpleFields.get("task");
        if (taskConfigString != null) {
            taskConfig = (TableTaskConfig)JsonUtils.stringToObject((String)taskConfigString, TableTaskConfig.class);
        }
        RoutingConfig routingConfig = null;
        String routingConfigString = (String)simpleFields.get("routing");
        if (routingConfigString != null) {
            routingConfig = (RoutingConfig)JsonUtils.stringToObject((String)routingConfigString, RoutingConfig.class);
        }
        QueryConfig queryConfig = null;
        String queryConfigString = (String)simpleFields.get("query");
        if (queryConfigString != null) {
            queryConfig = (QueryConfig)JsonUtils.stringToObject((String)queryConfigString, QueryConfig.class);
        }
        Map instanceAssignmentConfigMap = null;
        String instanceAssignmentConfigMapString = (String)simpleFields.get("instanceAssignmentConfigMap");
        if (instanceAssignmentConfigMapString != null) {
            instanceAssignmentConfigMap = (Map)JsonUtils.stringToObject((String)instanceAssignmentConfigMapString, (TypeReference)new TypeReference<Map<String, InstanceAssignmentConfig>>(){});
        }
        List fieldConfigList = null;
        String fieldConfigListString = (String)simpleFields.get("fieldConfigList");
        if (fieldConfigListString != null) {
            fieldConfigList = (List)JsonUtils.stringToObject((String)fieldConfigListString, (TypeReference)new TypeReference<List<FieldConfig>>(){});
        }
        UpsertConfig upsertConfig = null;
        String upsertConfigString = (String)simpleFields.get("upsertConfig");
        if (upsertConfigString != null) {
            upsertConfig = (UpsertConfig)JsonUtils.stringToObject((String)upsertConfigString, UpsertConfig.class);
        }
        DedupConfig dedupConfig = null;
        String dedupConfigString = (String)simpleFields.get("dedupConfig");
        if (dedupConfigString != null) {
            dedupConfig = (DedupConfig)JsonUtils.stringToObject((String)dedupConfigString, DedupConfig.class);
        }
        DimensionTableConfig dimensionTableConfig = null;
        String dimensionTableConfigString = (String)simpleFields.get("dimensionTableConfig");
        if (dimensionTableConfigString != null) {
            dimensionTableConfig = (DimensionTableConfig)JsonUtils.stringToObject((String)dimensionTableConfigString, DimensionTableConfig.class);
        }
        IngestionConfig ingestionConfig = null;
        String ingestionConfigString = (String)simpleFields.get("ingestionConfig");
        if (ingestionConfigString != null) {
            ingestionConfig = (IngestionConfig)JsonUtils.stringToObject((String)ingestionConfigString, IngestionConfig.class);
        }
        List tierConfigList = null;
        String tierConfigListString = (String)simpleFields.get("tierConfigs");
        if (tierConfigListString != null) {
            tierConfigList = (List)JsonUtils.stringToObject((String)tierConfigListString, (TypeReference)new TypeReference<List<TierConfig>>(){});
        }
        List tunerConfigList = null;
        String tunerConfigListString = (String)simpleFields.get("tunerConfigs");
        if (tunerConfigListString != null) {
            tunerConfigList = (List)JsonUtils.stringToObject((String)tunerConfigListString, (TypeReference)new TypeReference<List<TunerConfig>>(){});
        }
        Map instancePartitionsMap = null;
        String instancePartitionsMapString = (String)simpleFields.get("instancePartitionsMap");
        if (instancePartitionsMapString != null) {
            instancePartitionsMap = (Map)JsonUtils.stringToObject((String)instancePartitionsMapString, (TypeReference)new TypeReference<Map<InstancePartitionsType, String>>(){});
        }
        Map segmentAssignmentConfigMap = null;
        String segmentAssignmentConfigMapString = (String)simpleFields.get("segmentAssignmentConfigMap");
        if (segmentAssignmentConfigMapString != null) {
            segmentAssignmentConfigMap = (Map)JsonUtils.stringToObject((String)segmentAssignmentConfigMapString, (TypeReference)new TypeReference<Map<String, SegmentAssignmentConfig>>(){});
        }
        return new TableConfig(tableName, tableType, validationConfig, tenantConfig, indexingConfig, customConfig, quotaConfig, taskConfig, routingConfig, queryConfig, instanceAssignmentConfigMap, fieldConfigList, upsertConfig, dedupConfig, dimensionTableConfig, ingestionConfig, tierConfigList, isDimTable, tunerConfigList, instancePartitionsMap, segmentAssignmentConfigMap);
    }

    public static ZNRecord toZNRecord(TableConfig tableConfig) throws JsonProcessingException {
        Map segmentAssignmentConfigMap;
        List tunerConfigList;
        List tierConfigList;
        IngestionConfig ingestionConfig;
        DimensionTableConfig dimensionTableConfig;
        DedupConfig dedupConfig;
        UpsertConfig upsertConfig;
        List fieldConfigList;
        Map instanceAssignmentConfigMap;
        QueryConfig queryConfig;
        RoutingConfig routingConfig;
        TableTaskConfig taskConfig;
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        simpleFields.put("tableName", tableConfig.getTableName());
        simpleFields.put("tableType", tableConfig.getTableType().toString());
        simpleFields.put("segmentsConfig", tableConfig.getValidationConfig().toJsonString());
        simpleFields.put("tenants", tableConfig.getTenantConfig().toJsonString());
        simpleFields.put("tableIndexConfig", tableConfig.getIndexingConfig().toJsonString());
        simpleFields.put("metadata", tableConfig.getCustomConfig().toJsonString());
        simpleFields.put("isDimTable", Boolean.toString(tableConfig.isDimTable()));
        QuotaConfig quotaConfig = tableConfig.getQuotaConfig();
        if (quotaConfig != null) {
            simpleFields.put("quota", quotaConfig.toJsonString());
        }
        if ((taskConfig = tableConfig.getTaskConfig()) != null) {
            simpleFields.put("task", taskConfig.toJsonString());
        }
        if ((routingConfig = tableConfig.getRoutingConfig()) != null) {
            simpleFields.put("routing", routingConfig.toJsonString());
        }
        if ((queryConfig = tableConfig.getQueryConfig()) != null) {
            simpleFields.put("query", queryConfig.toJsonString());
        }
        if ((instanceAssignmentConfigMap = tableConfig.getInstanceAssignmentConfigMap()) != null) {
            simpleFields.put("instanceAssignmentConfigMap", JsonUtils.objectToString((Object)instanceAssignmentConfigMap));
        }
        if ((fieldConfigList = tableConfig.getFieldConfigList()) != null) {
            simpleFields.put("fieldConfigList", JsonUtils.objectToString((Object)fieldConfigList));
        }
        if ((upsertConfig = tableConfig.getUpsertConfig()) != null) {
            simpleFields.put("upsertConfig", JsonUtils.objectToString((Object)upsertConfig));
        }
        if ((dedupConfig = tableConfig.getDedupConfig()) != null) {
            simpleFields.put("dedupConfig", JsonUtils.objectToString((Object)dedupConfig));
        }
        if ((dimensionTableConfig = tableConfig.getDimensionTableConfig()) != null) {
            simpleFields.put("dimensionTableConfig", JsonUtils.objectToString((Object)dimensionTableConfig));
        }
        if ((ingestionConfig = tableConfig.getIngestionConfig()) != null) {
            simpleFields.put("ingestionConfig", JsonUtils.objectToString((Object)ingestionConfig));
        }
        if ((tierConfigList = tableConfig.getTierConfigsList()) != null) {
            simpleFields.put("tierConfigs", JsonUtils.objectToString((Object)tierConfigList));
        }
        if ((tunerConfigList = tableConfig.getTunerConfigsList()) != null) {
            simpleFields.put("tunerConfigs", JsonUtils.objectToString((Object)tunerConfigList));
        }
        if (tableConfig.getInstancePartitionsMap() != null) {
            simpleFields.put("instancePartitionsMap", JsonUtils.objectToString((Object)tableConfig.getInstancePartitionsMap()));
        }
        if ((segmentAssignmentConfigMap = tableConfig.getSegmentAssignmentConfigMap()) != null) {
            simpleFields.put("segmentAssignmentConfigMap", JsonUtils.objectToString((Object)segmentAssignmentConfigMap));
        }
        ZNRecord znRecord = new ZNRecord(tableConfig.getTableName());
        znRecord.setSimpleFields(simpleFields);
        return znRecord;
    }

    public static void convertFromLegacyTableConfig(TableConfig tableConfig) {
        Map streamConfigs;
        IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
        BatchIngestionConfig batchIngestionConfig = ingestionConfig != null ? ingestionConfig.getBatchIngestionConfig() : null;
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        String segmentPushType = validationConfig.getSegmentPushType();
        String segmentPushFrequency = validationConfig.getSegmentPushFrequency();
        if (batchIngestionConfig == null) {
            if (segmentPushType != null || segmentPushFrequency != null) {
                batchIngestionConfig = new BatchIngestionConfig(null, segmentPushType, segmentPushFrequency);
            }
        } else {
            if (batchIngestionConfig.getSegmentIngestionType() == null) {
                batchIngestionConfig.setSegmentIngestionType(segmentPushType);
            }
            if (batchIngestionConfig.getSegmentIngestionFrequency() == null) {
                batchIngestionConfig.setSegmentIngestionFrequency(segmentPushFrequency);
            }
        }
        StreamIngestionConfig streamIngestionConfig = ingestionConfig != null ? ingestionConfig.getStreamIngestionConfig() : null;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (streamIngestionConfig == null && MapUtils.isNotEmpty((Map)(streamConfigs = indexingConfig.getStreamConfigs()))) {
            streamIngestionConfig = new StreamIngestionConfig(Collections.singletonList(streamConfigs));
        }
        if (ingestionConfig == null) {
            if (batchIngestionConfig != null || streamIngestionConfig != null) {
                ingestionConfig = new IngestionConfig();
                ingestionConfig.setBatchIngestionConfig(batchIngestionConfig);
                ingestionConfig.setStreamIngestionConfig(streamIngestionConfig);
            }
        } else {
            ingestionConfig.setBatchIngestionConfig(batchIngestionConfig);
            ingestionConfig.setStreamIngestionConfig(streamIngestionConfig);
        }
        tableConfig.setIngestionConfig(ingestionConfig);
        indexingConfig.setStreamConfigs(null);
        validationConfig.setSegmentPushFrequency(null);
        validationConfig.setSegmentPushType(null);
    }

    public static TableConfig overwriteTableConfigForTier(TableConfig tableConfig, @Nullable String tier) {
        if (tier == null) {
            return tableConfig;
        }
        try {
            JsonNode fieldCfgListJson;
            JsonNode tierCfgJson;
            boolean updated = false;
            JsonNode tblCfgJson = tableConfig.toJsonNode();
            JsonNode tblIdxCfgJson = tblCfgJson.get("tableIndexConfig");
            if (tblIdxCfgJson != null && tblIdxCfgJson.has("tierOverwrites") && (tierCfgJson = tblIdxCfgJson.get("tierOverwrites").get(tier)) != null) {
                LOGGER.debug("Got table index config overwrites: {} for tier: {}", (Object)tierCfgJson, (Object)tier);
                TableConfigUtils.overwriteConfig(tblIdxCfgJson, tierCfgJson);
                updated = true;
            }
            if ((fieldCfgListJson = tblCfgJson.get("fieldConfigList")) != null && fieldCfgListJson.isArray()) {
                Iterator fieldCfgListItr = fieldCfgListJson.elements();
                while (fieldCfgListItr.hasNext()) {
                    JsonNode tierCfgJson2;
                    JsonNode fieldCfgJson = (JsonNode)fieldCfgListItr.next();
                    if (!fieldCfgJson.has("tierOverwrites") || (tierCfgJson2 = fieldCfgJson.get("tierOverwrites").get(tier)) == null) continue;
                    LOGGER.debug("Got field index config overwrites: {} for tier: {}", (Object)tierCfgJson2, (Object)tier);
                    TableConfigUtils.overwriteConfig(fieldCfgJson, tierCfgJson2);
                    updated = true;
                }
            }
            if (updated) {
                LOGGER.debug("Got overwritten table config: {} for tier: {}", (Object)tblCfgJson, (Object)tier);
                return (TableConfig)JsonUtils.jsonNodeToObject((JsonNode)tblCfgJson, TableConfig.class);
            }
            LOGGER.debug("No table config overwrites for tier: {}", (Object)tier);
            return tableConfig;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to overwrite table config for tier: {} for table: {}", new Object[]{tier, tableConfig.getTableName(), e});
            return tableConfig;
        }
    }

    private static void overwriteConfig(JsonNode oldCfg, JsonNode newCfg) {
        Iterator cfgItr = newCfg.fields();
        while (cfgItr.hasNext()) {
            Map.Entry cfgEntry = (Map.Entry)cfgItr.next();
            ((ObjectNode)oldCfg).set((String)cfgEntry.getKey(), (JsonNode)cfgEntry.getValue());
        }
    }

    public static boolean hasPreConfiguredInstancePartitions(TableConfig tableConfig) {
        return MapUtils.isNotEmpty((Map)tableConfig.getInstancePartitionsMap());
    }

    public static boolean hasPreConfiguredInstancePartitions(TableConfig tableConfig, InstancePartitionsType instancePartitionsType) {
        return TableConfigUtils.hasPreConfiguredInstancePartitions(tableConfig) && tableConfig.getInstancePartitionsMap().containsKey(instancePartitionsType);
    }

    public static String getPartitionColumn(TableConfig tableConfig) {
        ReplicaGroupStrategyConfig replicaGroupStrategyConfig;
        if (!MapUtils.isEmpty((Map)tableConfig.getInstanceAssignmentConfigMap())) {
            for (InstanceAssignmentConfig instanceAssignmentConfig : tableConfig.getInstanceAssignmentConfigMap().values()) {
                if (!StringUtils.isNotEmpty((CharSequence)instanceAssignmentConfig.getReplicaGroupPartitionConfig().getPartitionColumn())) continue;
                return instanceAssignmentConfig.getReplicaGroupPartitionConfig().getPartitionColumn();
            }
        }
        return (replicaGroupStrategyConfig = tableConfig.getValidationConfig().getReplicaGroupStrategyConfig()) != null ? replicaGroupStrategyConfig.getPartitionColumn() : null;
    }
}

