/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.grpc;

import com.google.common.base.Supplier;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import nl.altindag.ssl.SSLFactory;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.tls.PinotInsecureMode;
import org.apache.pinot.common.utils.tls.RenewableTlsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcQueryClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcQueryClient.class);
    private static final Map<Integer, SslContext> CLIENT_SSL_CONTEXTS_CACHE = new ConcurrentHashMap<Integer, SslContext>();
    private final ManagedChannel _managedChannel;
    private final PinotQueryServerGrpc.PinotQueryServerBlockingStub _blockingStub;
    private final int _channelShutdownTimeoutSeconds;

    public GrpcQueryClient(String host, int port) {
        this(host, port, new GrpcConfig(Collections.emptyMap()));
    }

    public GrpcQueryClient(String host, int port, GrpcConfig config) {
        Object channelBuilder = config.isUsePlainText() ? ManagedChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).usePlaintext() : NettyChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes()).sslContext(GrpcQueryClient.buildSslContext(config.getTlsConfig()));
        int channelKeepAliveTimeSeconds = config.getChannelKeepAliveTimeSeconds();
        if (channelKeepAliveTimeSeconds > 0) {
            channelBuilder.keepAliveTime((long)channelKeepAliveTimeSeconds, TimeUnit.SECONDS).keepAliveTimeout((long)config.getChannelKeepAliveTimeoutSeconds(), TimeUnit.SECONDS).keepAliveWithoutCalls(config.isChannelKeepAliveWithoutCalls());
        }
        this._managedChannel = channelBuilder.build();
        this._blockingStub = PinotQueryServerGrpc.newBlockingStub((Channel)this._managedChannel);
        this._channelShutdownTimeoutSeconds = config.getChannelShutdownTimeoutSecond();
    }

    public static SslContext buildSslContext(TlsConfig tlsConfig) {
        LOGGER.info("Building gRPC client SSL context");
        return CLIENT_SSL_CONTEXTS_CACHE.computeIfAbsent(tlsConfig.hashCode(), tlsConfigHashCode -> {
            try {
                SSLFactory sslFactory = RenewableTlsUtils.createSSLFactoryAndEnableAutoRenewalWhenUsingFileStores(tlsConfig, (Supplier<Boolean>)((Supplier)PinotInsecureMode::isPinotInInsecureMode));
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                sslFactory.getKeyManagerFactory().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).keyManager(arg_0));
                sslFactory.getTrustManagerFactory().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
                sslContextBuilder = tlsConfig.getSslProvider() != null ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.valueOf((String)tlsConfig.getSslProvider())) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
                return sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw new RuntimeException("Failed to build gRPC client SSL context", e);
            }
        });
    }

    public Iterator<Server.ServerResponse> submit(Server.ServerRequest request) {
        return this._blockingStub.submit(request);
    }

    @Override
    public void close() {
        if (!this._managedChannel.isShutdown()) {
            try {
                this._managedChannel.shutdownNow();
                if (!this._managedChannel.awaitTermination((long)this._channelShutdownTimeoutSeconds, TimeUnit.SECONDS)) {
                    LOGGER.warn("Timed out forcefully shutting down connection: {}. ", (Object)this._managedChannel);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }
}

