/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.log;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.utils.log.LogFileServer;

public class LocalLogFileServer
implements LogFileServer {
    private final File _logRootDir;
    private final Path _logRootDirPath;

    public LocalLogFileServer(String logRootDir) {
        Preconditions.checkNotNull((Object)logRootDir, (Object)"Log root directory is null");
        this._logRootDir = new File(logRootDir);
        Preconditions.checkState((boolean)this._logRootDir.exists(), (Object)"Log directory doesn't exists");
        this._logRootDirPath = Paths.get(this._logRootDir.getAbsolutePath(), new String[0]);
    }

    @Override
    public Set<String> getAllLogFilePaths() throws IOException {
        TreeSet<String> allFiles = new TreeSet<String>();
        Files.walk(this._logRootDirPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> allFiles.add(f.toAbsolutePath().toString().replace(this._logRootDirPath.toAbsolutePath() + "/", "")));
        return allFiles;
    }

    @Override
    public Response downloadLogFile(String filePath) {
        try {
            if (!this.getAllLogFilePaths().contains(filePath)) {
                throw new WebApplicationException("Invalid file path: " + filePath, Response.Status.FORBIDDEN);
            }
            File logFile = new File(this._logRootDir, filePath);
            if (!logFile.exists()) {
                throw new WebApplicationException("File: " + filePath + " doesn't exists", Response.Status.NOT_FOUND);
            }
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)logFile);
            builder.entity(output -> Files.copy(logFile.toPath(), output));
            builder.header("Content-Disposition", (Object)("attachment; filename=" + logFile.getName()));
            builder.header("Content-Length", (Object)logFile.length());
            return builder.build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

