/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.regex;

import org.apache.pinot.common.utils.regex.JavaUtilPattern;
import org.apache.pinot.common.utils.regex.Pattern;
import org.apache.pinot.common.utils.regex.Re2jPattern;
import org.apache.pinot.common.utils.regex.RegexClass;

public class PatternFactory {
    private static RegexClass _regexClass;

    private PatternFactory() {
    }

    public static void init(String regexClass) {
        _regexClass = RegexClass.valueOf(regexClass);
    }

    public static Pattern compile(String regex) {
        if (_regexClass == null) {
            return new JavaUtilPattern(regex);
        }
        switch (_regexClass) {
            case RE2J: {
                return new Re2jPattern(regex);
            }
        }
        return new JavaUtilPattern(regex);
    }
}

