/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.tls;

import com.google.common.base.Supplier;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import nl.altindag.ssl.SSLFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.tls.RenewableTlsUtils;
import org.apache.pinot.common.utils.tls.TlsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmDefaultSslContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmDefaultSslContext.class);
    private static final String JVM_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JVM_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String JVM_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String JVM_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JVM_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String JVM_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static volatile boolean _initialized = false;

    private JvmDefaultSslContext() {
        throw new IllegalStateException("Should not instantiate JvmDefaultSslContext");
    }

    public static synchronized void initDefaultSslContext() {
        LOGGER.info("Trying to initialize jvm default SSL context");
        if (_initialized) {
            LOGGER.info("Jvm default SSL context has already been initialized");
            return;
        }
        String jvmKeyStorePath = System.getProperty(JVM_KEY_STORE);
        String jvmTrustStorePath = System.getProperty(JVM_TRUST_STORE);
        if (TlsUtils.isKeyOrTrustStorePathNullOrHasFileScheme(jvmKeyStorePath) && TlsUtils.isKeyOrTrustStorePathNullOrHasFileScheme(jvmTrustStorePath) && (StringUtils.isNotBlank((CharSequence)jvmKeyStorePath) || StringUtils.isNotBlank((CharSequence)jvmTrustStorePath))) {
            SSLFactory.Builder jvmSslFactoryBuilder = SSLFactory.builder();
            if (StringUtils.isNotBlank((CharSequence)jvmKeyStorePath)) {
                jvmSslFactoryBuilder.withSwappableIdentityMaterial().withSystemPropertyDerivedIdentityMaterial();
            }
            if (StringUtils.isNotBlank((CharSequence)jvmTrustStorePath)) {
                jvmSslFactoryBuilder.withSwappableTrustMaterial().withSystemPropertyDerivedTrustMaterial();
            } else {
                jvmSslFactoryBuilder.withDefaultTrustMaterial();
            }
            SSLFactory jvmSslFactory = jvmSslFactoryBuilder.build();
            SSLContext.setDefault(jvmSslFactory.getSslContext());
            String jvmKeystoreType = Optional.ofNullable(System.getProperty(JVM_TRUST_STORE_TYPE)).map(String::trim).filter(StringUtils::isNotBlank).orElseGet(KeyStore::getDefaultType);
            String jvmKeystorePassword = Optional.ofNullable(System.getProperty(JVM_KEY_STORE_PASSWORD)).map(String::trim).filter(StringUtils::isNotBlank).orElse(null);
            String jvmTrustStoreType = Optional.ofNullable(System.getProperty(JVM_TRUST_STORE_TYPE)).map(String::trim).filter(StringUtils::isNotBlank).orElseGet(KeyStore::getDefaultType);
            String jvmTrustStorePassword = Optional.ofNullable(System.getProperty(JVM_TRUST_STORE_PASSWORD)).map(String::trim).filter(StringUtils::isNotBlank).orElse(null);
            RenewableTlsUtils.enableAutoRenewalFromFileStoreForSSLFactory(jvmSslFactory, jvmKeystoreType, jvmKeyStorePath, jvmKeystorePassword, jvmTrustStoreType, jvmTrustStorePath, jvmTrustStorePassword, null, null, (Supplier<Boolean>)((Supplier)() -> false));
        }
        _initialized = true;
        LOGGER.info("Successfully initialized mvm default SSL context");
    }
}

