/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.dml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.config.task.AdhocTaskConfig;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.apache.pinot.sql.parsers.dml.DataManipulationStatement;
import org.apache.pinot.sql.parsers.parser.SqlInsertFromFile;

public class InsertIntoFile
implements DataManipulationStatement {
    private static final DataSchema INSERT_FROM_FILE_RESPONSE_SCHEMA = new DataSchema(new String[]{"tableName", "taskJobName"}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING, DataSchema.ColumnDataType.STRING});
    private static final String TASK_NAME = "taskName";
    private static final String TASK_TYPE = "taskType";
    private static final String DEFAULT_TASK_TYPE = "SegmentGenerationAndPushTask";
    private static final String INPUT_DIR_URI = "inputDirURI";
    private final String _table;
    private final Map<String, String> _queryOptions;

    public InsertIntoFile(String table, Map<String, String> queryOptions) {
        this._table = table;
        this._queryOptions = queryOptions;
    }

    public String getTable() {
        return this._table;
    }

    public Map<String, String> getQueryOptions() {
        return this._queryOptions;
    }

    public static InsertIntoFile parse(SqlNodeAndOptions sqlNodeAndOptions) {
        SqlNode sqlNode = sqlNodeAndOptions.getSqlNode();
        assert (sqlNode instanceof SqlInsertFromFile);
        SqlInsertFromFile sqlInsertFromFile = (SqlInsertFromFile)sqlNode;
        List<SqlNode> operandList = sqlInsertFromFile.getOperandList();
        String tableName = operandList.get(0) != null ? StringUtils.joinWith((String)",", (Object[])new Object[]{operandList.get(0), operandList.get(1)}) : operandList.get(1).toString();
        Map<String, String> optionsMap = sqlNodeAndOptions.getOptions();
        ArrayList inputDirList = new ArrayList();
        ((SqlNodeList)operandList.get(2)).getList().forEach(sqlNode1 -> inputDirList.add(sqlNode1.toString().replace("'", "")));
        optionsMap.put(INPUT_DIR_URI, StringUtils.join(inputDirList, (String)","));
        return new InsertIntoFile(tableName, optionsMap);
    }

    @Override
    public DataManipulationStatement.ExecutionType getExecutionType() {
        return DataManipulationStatement.ExecutionType.MINION;
    }

    @Override
    public AdhocTaskConfig generateAdhocTaskConfig() {
        Map<String, String> queryOptions = this.getQueryOptions();
        String taskName = queryOptions.get(TASK_NAME);
        String taskType = queryOptions.getOrDefault(TASK_TYPE, DEFAULT_TASK_TYPE);
        return new AdhocTaskConfig(taskType, this.getTable(), taskName, queryOptions);
    }

    @Override
    public List<Object[]> execute() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DataSchema getResultSchema() {
        return INSERT_FROM_FILE_RESPONSE_SCHEMA;
    }
}

