/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.pinot.client.BrokerData;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.ControllerRequestURLBuilder;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;

public class BrokerCache {
    private static final TypeReference<Map<String, List<BrokerInstance>>> RESPONSE_TYPE_REF = new TypeReference<Map<String, List<BrokerInstance>>>(){};
    private final Random _random = new Random();
    private final AsyncHttpClient _client = Dsl.asyncHttpClient();
    private final String _address;
    private volatile BrokerData _brokerData;

    public BrokerCache(String scheme, String controllerHost, int controllerPort) {
        ControllerRequestURLBuilder controllerRequestURLBuilder = ControllerRequestURLBuilder.baseUrl((String)(scheme + "://" + controllerHost + ":" + controllerPort));
        this._address = controllerRequestURLBuilder.forLiveBrokerTablesGet();
    }

    private Map<String, List<BrokerInstance>> getTableToBrokersData() throws Exception {
        BoundRequestBuilder getRequest = this._client.prepareGet(this._address);
        ListenableFuture responseFuture = ((BoundRequestBuilder)getRequest.addHeader((CharSequence)"accept", "application/json")).execute();
        Response response = (Response)responseFuture.get();
        String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
        return (Map)JsonUtils.stringToObject((String)responseBody, RESPONSE_TYPE_REF);
    }

    private BrokerData getBrokerData(Map<String, List<BrokerInstance>> responses) {
        HashSet brokers = new HashSet();
        HashMap<String, List<String>> tableToBrokersMap = new HashMap<String, List<String>>();
        HashSet<String> uniqueTableNames = new HashSet<String>();
        for (Map.Entry<String, List<BrokerInstance>> tableToBrokers : responses.entrySet()) {
            ArrayList brokersForTable = new ArrayList();
            tableToBrokers.getValue().forEach(br -> {
                String brokerHostPort = br.getHost() + ":" + br.getPort();
                brokersForTable.add(brokerHostPort);
                brokers.add(brokerHostPort);
            });
            String tableName2 = tableToBrokers.getKey();
            tableToBrokersMap.put(tableName2, brokersForTable);
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableName2);
            uniqueTableNames.add(rawTableName);
        }
        uniqueTableNames.forEach(tableName -> {
            if (!tableToBrokersMap.containsKey(tableName)) {
                String offlineTable = tableName + "_OFFLINE";
                String realtimeTable = tableName + "_REALTIME";
                if (tableToBrokersMap.containsKey(offlineTable) && tableToBrokersMap.containsKey(realtimeTable)) {
                    List realtimeBrokers = (List)tableToBrokersMap.get(realtimeTable);
                    List offlineBrokers = (List)tableToBrokersMap.get(offlineTable);
                    List tableBrokers = realtimeBrokers.stream().filter(offlineBrokers::contains).collect(Collectors.toList());
                    tableToBrokersMap.put((String)tableName, tableBrokers);
                } else {
                    tableToBrokersMap.put((String)tableName, tableToBrokersMap.getOrDefault(offlineTable, tableToBrokersMap.getOrDefault(realtimeTable, new ArrayList())));
                }
            }
        });
        return new BrokerData(tableToBrokersMap, new ArrayList<String>(brokers));
    }

    protected void updateBrokerData() throws Exception {
        Map<String, List<BrokerInstance>> responses = this.getTableToBrokersData();
        this._brokerData = this.getBrokerData(responses);
    }

    public String getBroker(String tableName) {
        List<String> brokers = tableName == null ? this._brokerData.getBrokers() : this._brokerData.getTableToBrokerMap().get(tableName);
        return brokers.get(this._random.nextInt(brokers.size()));
    }

    public List<String> getBrokers() {
        return this._brokerData.getBrokers();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class BrokerInstance {
        private String _host;
        private Integer _port;

        private BrokerInstance() {
        }

        public String getHost() {
            return this._host;
        }

        public void setHost(String host) {
            this._host = host;
        }

        public Integer getPort() {
            return this._port;
        }

        public void setPort(Integer port) {
            this._port = port;
        }
    }
}

