/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.client.BrokerCache;
import org.apache.pinot.client.UpdatableBrokerCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerCacheUpdaterPeriodic
implements UpdatableBrokerCache {
    private final BrokerCache _brokerCache;
    private final ScheduledExecutorService _scheduledExecutorService;
    private final long _brokerUpdateFreqInMillis;
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerCacheUpdaterPeriodic.class);

    public BrokerCacheUpdaterPeriodic(String scheme, String controllerHost, int controllerPort, long brokerUpdateFreqInMillis) {
        this._brokerCache = new BrokerCache(scheme, controllerHost, controllerPort);
        this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this._brokerUpdateFreqInMillis = brokerUpdateFreqInMillis;
    }

    @Override
    public void init() throws Exception {
        this._brokerCache.updateBrokerData();
        if (this._brokerUpdateFreqInMillis > 0L) {
            this._scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerCacheUpdaterPeriodic.this._brokerCache.updateBrokerData();
                    }
                    catch (Exception e) {
                        LOGGER.error("Broker cache update failed", (Throwable)e);
                    }
                }
            }, 0L, this._brokerUpdateFreqInMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public String getBroker(String tableName) {
        return this._brokerCache.getBroker(tableName);
    }

    @Override
    public List<String> getBrokers() {
        return this._brokerCache.getBrokers();
    }

    @Override
    public void triggerBrokerCacheUpdate() throws Exception {
        this._brokerCache.updateBrokerData();
    }

    @Override
    public void close() {
        try {
            this._scheduledExecutorService.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("Cannot shutdown Broker Cache update periodic task", (Throwable)e);
        }
    }
}

