/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.ControllerBasedBrokerSelector;
import org.apache.pinot.client.DynamicBrokerSelector;
import org.apache.pinot.client.JsonAsyncHttpPinotClientTransportFactory;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;

public class ConnectionFactory {
    private static PinotClientTransport _defaultTransport;

    private ConnectionFactory() {
    }

    public static Connection fromZookeeper(String zkUrl) {
        return ConnectionFactory.fromZookeeper(zkUrl, ConnectionFactory.getDefault());
    }

    public static Connection fromZookeeper(String zkUrl, PinotClientTransport transport) {
        try {
            return ConnectionFactory.fromZookeeper(new DynamicBrokerSelector(zkUrl), transport);
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    public static Connection fromController(String scheme, String controllerHost, int controllerPort) {
        return ConnectionFactory.fromController(scheme, controllerHost, controllerPort, 1000L);
    }

    public static Connection fromController(String scheme, String controllerHost, int controllerPort, long brokerUpdateFreqInMillis) {
        try {
            return new Connection(new Properties(), new ControllerBasedBrokerSelector(scheme, controllerHost, controllerPort, brokerUpdateFreqInMillis), ConnectionFactory.getDefault());
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    public static Connection fromZookeeper(Properties properties, String zkUrl, PinotClientTransport transport) {
        try {
            return ConnectionFactory.fromZookeeper(properties, new DynamicBrokerSelector(zkUrl), transport);
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @VisibleForTesting
    static Connection fromZookeeper(DynamicBrokerSelector dynamicBrokerSelector, PinotClientTransport transport) {
        return ConnectionFactory.fromZookeeper(new Properties(), dynamicBrokerSelector, transport);
    }

    @VisibleForTesting
    static Connection fromZookeeper(Properties properties, DynamicBrokerSelector dynamicBrokerSelector, PinotClientTransport transport) {
        return new Connection(properties, dynamicBrokerSelector, transport);
    }

    public static Connection fromProperties(Properties properties) {
        return ConnectionFactory.fromProperties(properties, ConnectionFactory.getDefault(properties));
    }

    public static Connection fromProperties(Properties properties, PinotClientTransport transport) {
        return new Connection(properties, Arrays.asList(properties.getProperty("brokerList").split(",")), transport);
    }

    public static Connection fromHostList(String ... brokers) {
        return ConnectionFactory.fromHostList(Arrays.asList(brokers), ConnectionFactory.getDefault());
    }

    public static Connection fromHostList(List<String> brokers, PinotClientTransport transport) {
        return new Connection(brokers, transport);
    }

    public static Connection fromHostList(Properties properties, List<String> brokers, PinotClientTransport transport) {
        return new Connection(properties, brokers, transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PinotClientTransport getDefault(Properties connectionProperties) {
        if (_defaultTransport != null) return _defaultTransport;
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (_defaultTransport != null) return _defaultTransport;
            _defaultTransport = new JsonAsyncHttpPinotClientTransportFactory().withConnectionProperties(connectionProperties).buildTransport();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _defaultTransport;
        }
    }

    private static PinotClientTransport getDefault() {
        return ConnectionFactory.getDefault(new Properties());
    }
}

