/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.List;
import org.apache.pinot.client.BrokerCacheUpdaterPeriodic;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.UpdatableBrokerCache;

public class ControllerBasedBrokerSelector
implements BrokerSelector {
    private final UpdatableBrokerCache _brokerCache;

    public ControllerBasedBrokerSelector(String scheme, String controllerHost, int controllerPort, long brokerUpdateFreqInMillis) throws Exception {
        this._brokerCache = new BrokerCacheUpdaterPeriodic(scheme, controllerHost, controllerPort, brokerUpdateFreqInMillis);
        this._brokerCache.init();
    }

    @Override
    public String selectBroker(String table) {
        return this._brokerCache.getBroker(table);
    }

    @Override
    public List<String> getBrokers() {
        return this._brokerCache.getBrokers();
    }

    @Override
    public void close() {
        this._brokerCache.close();
    }

    public void updateBrokers() throws Exception {
        this._brokerCache.triggerBrokerCacheUpdate();
    }
}

