/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.client.AbstractResultSet;
import org.apache.pinot.client.TextTable;

public class ResultTableResultSet
extends AbstractResultSet {
    private final JsonNode _rowsArray;
    private final JsonNode _columnNamesArray;
    private final JsonNode _columnDataTypesArray;

    public ResultTableResultSet(JsonNode resultTable) {
        this._rowsArray = resultTable.get("rows");
        JsonNode dataSchema = resultTable.get("dataSchema");
        this._columnNamesArray = dataSchema.get("columnNames");
        this._columnDataTypesArray = dataSchema.get("columnDataTypes");
    }

    @Override
    public int getRowCount() {
        return this._rowsArray.size();
    }

    @Override
    public int getColumnCount() {
        return this._columnNamesArray.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._columnNamesArray.get(columnIndex).asText();
    }

    @Override
    public String getColumnDataType(int columnIndex) {
        return this._columnDataTypesArray.get(columnIndex).asText();
    }

    @Override
    public String getString(int rowIndex, int columnIndex) {
        JsonNode jsonValue = this._rowsArray.get(rowIndex).get(columnIndex);
        if (jsonValue.isTextual()) {
            return jsonValue.textValue();
        }
        return jsonValue.toString();
    }

    public List<String> getAllColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this._columnNamesArray == null) {
            return columns;
        }
        for (JsonNode column : this._columnNamesArray) {
            columns.add(column.textValue());
        }
        return columns;
    }

    public List<String> getAllColumnsDataTypes() {
        ArrayList<String> columnDataTypes = new ArrayList<String>();
        if (this._columnDataTypesArray == null) {
            return columnDataTypes;
        }
        for (JsonNode columnDataType : this._columnDataTypesArray) {
            columnDataTypes.add(columnDataType.textValue());
        }
        return columnDataTypes;
    }

    @Override
    public int getGroupKeyLength() {
        return 0;
    }

    @Override
    public String getGroupKeyString(int rowIndex, int groupKeyColumnIndex) {
        throw new AssertionError((Object)"No group key string for result table");
    }

    @Override
    public String getGroupKeyColumnName(int groupKeyColumnIndex) {
        throw new AssertionError((Object)"No group key column name for result table");
    }

    public String toString() {
        int numColumns = this.getColumnCount();
        TextTable table = new TextTable();
        String[] columnNames = new String[numColumns];
        String[] columnDataTypes = new String[numColumns];
        for (int c = 0; c < numColumns; ++c) {
            columnNames[c] = this._columnNamesArray.get(c).asText();
            columnDataTypes[c] = this._columnDataTypesArray.get(c).asText();
        }
        table.addHeader(columnNames);
        table.addHeader(columnDataTypes);
        int numRows = this.getRowCount();
        for (int r = 0; r < numRows; ++r) {
            String[] columnValues = new String[numColumns];
            for (int c = 0; c < numColumns; ++c) {
                try {
                    columnValues[c] = this.getString(r, c);
                    continue;
                }
                catch (Exception e) {
                    columnNames[c] = "ERROR";
                }
            }
            table.addRow(columnValues);
        }
        return table.toString();
    }
}

