/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PreparedStatement;
import org.apache.pinot.client.Request;
import org.apache.pinot.client.ResultSetGroup;
import org.apache.pinot.client.SimpleBrokerSelector;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    public static final String FAIL_ON_EXCEPTIONS = "failOnExceptions";
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final PinotClientTransport _transport;
    private final BrokerSelector _brokerSelector;
    private final boolean _failOnExceptions;

    Connection(List<String> brokerList, PinotClientTransport transport) {
        this(new Properties(), new SimpleBrokerSelector(brokerList), transport);
    }

    Connection(Properties properties, List<String> brokerList, PinotClientTransport transport) {
        this(properties, new SimpleBrokerSelector(brokerList), transport);
        LOGGER.info("Created connection to broker list {}", brokerList);
    }

    Connection(BrokerSelector brokerSelector, PinotClientTransport transport) {
        this(new Properties(), brokerSelector, transport);
    }

    Connection(Properties properties, BrokerSelector brokerSelector, PinotClientTransport transport) {
        this._brokerSelector = brokerSelector;
        this._transport = transport;
        this._failOnExceptions = Boolean.parseBoolean(properties.getProperty(FAIL_ON_EXCEPTIONS, "TRUE"));
    }

    public PreparedStatement prepareStatement(String query) {
        return new PreparedStatement(this, query);
    }

    @Deprecated
    public PreparedStatement prepareStatement(Request request) {
        return new PreparedStatement(this, request);
    }

    public ResultSetGroup execute(String query) {
        return this.execute(null, query);
    }

    @Deprecated
    public ResultSetGroup execute(Request request) throws PinotClientException {
        return this.execute(null, request);
    }

    public ResultSetGroup execute(@Nullable String tableName, String query) throws PinotClientException {
        String brokerHostPort = this._brokerSelector.selectBroker(tableName = tableName == null ? Connection.resolveTableName(query) : tableName);
        if (brokerHostPort == null) {
            throw new PinotClientException("Could not find broker to query for table: " + tableName);
        }
        BrokerResponse response = this._transport.executeQuery(brokerHostPort, query);
        if (response.hasExceptions() && this._failOnExceptions) {
            throw new PinotClientException("Query had processing exceptions: \n" + response.getExceptions());
        }
        return new ResultSetGroup(response);
    }

    @Deprecated
    public ResultSetGroup execute(@Nullable String tableName, Request request) throws PinotClientException {
        return this.execute(tableName, request.getQuery());
    }

    public Future<ResultSetGroup> executeAsync(String query) throws PinotClientException {
        return this.executeAsync(null, query);
    }

    @Deprecated
    public Future<ResultSetGroup> executeAsync(Request request) throws PinotClientException {
        return this.executeAsync(null, request.getQuery());
    }

    public Future<ResultSetGroup> executeAsync(@Nullable String tableName, String query) throws PinotClientException {
        String brokerHostPort = this._brokerSelector.selectBroker(tableName = tableName == null ? Connection.resolveTableName(query) : tableName);
        if (brokerHostPort == null) {
            throw new PinotClientException("Could not find broker to query for statement: " + query);
        }
        return new ResultSetGroupFuture(this._transport.executeQueryAsync(brokerHostPort, query));
    }

    @Nullable
    private static String resolveTableName(String query) {
        try {
            return CalciteSqlCompiler.compileToBrokerRequest((String)query).querySource.tableName;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse table name from query: {}", (Object)query, (Object)e);
            return null;
        }
    }

    List<String> getBrokerList() {
        return this._brokerSelector.getBrokers();
    }

    public void close() throws PinotClientException {
        this._transport.close();
        this._brokerSelector.close();
    }

    private static class ResultSetGroupFuture
    implements Future<ResultSetGroup> {
        private final Future<BrokerResponse> _responseFuture;

        public ResultSetGroupFuture(Future<BrokerResponse> responseFuture) {
            this._responseFuture = responseFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._responseFuture.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this._responseFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._responseFuture.isDone();
        }

        @Override
        public ResultSetGroup get() throws InterruptedException, ExecutionException {
            try {
                return this.get(60000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public ResultSetGroup get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            BrokerResponse response = this._responseFuture.get(timeout, unit);
            return new ResultSetGroup(response);
        }
    }
}

