/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.ControllerBasedBrokerSelector;
import org.apache.pinot.client.DynamicBrokerSelector;
import org.apache.pinot.client.JsonAsyncHttpPinotClientTransportFactory;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;

public class ConnectionFactory {
    private static PinotClientTransport _defaultTransport;

    private ConnectionFactory() {
    }

    public static Connection fromZookeeper(String zkUrl) {
        return ConnectionFactory.fromZookeeper(zkUrl, ConnectionFactory.getDefault());
    }

    public static Connection fromZookeeper(String zkUrl, PinotClientTransport transport) {
        try {
            return ConnectionFactory.fromZookeeper(new DynamicBrokerSelector(zkUrl), transport);
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    public static Connection fromZookeeper(Properties properties, String zkUrl) {
        try {
            return ConnectionFactory.fromZookeeper(properties, new DynamicBrokerSelector(zkUrl), ConnectionFactory.getDefault(properties));
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @Deprecated
    public static Connection fromController(String scheme, String controllerHost, int controllerPort) {
        return ConnectionFactory.fromController(new Properties(), scheme, controllerHost, controllerPort);
    }

    @Deprecated
    public static Connection fromController(Properties properties, String scheme, String controllerHost, int controllerPort) {
        try {
            return new Connection(properties, new ControllerBasedBrokerSelector(scheme, controllerHost, controllerPort, properties), ConnectionFactory.getDefault());
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    public static Connection fromController(String controllerUrl) {
        return ConnectionFactory.fromController(new Properties(), controllerUrl);
    }

    public static Connection fromController(Properties properties, String controllerUrl) {
        try {
            return new Connection(properties, new ControllerBasedBrokerSelector(properties, controllerUrl), ConnectionFactory.getDefault(properties));
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    public static Connection fromZookeeper(Properties properties, String zkUrl, PinotClientTransport transport) {
        try {
            return ConnectionFactory.fromZookeeper(properties, new DynamicBrokerSelector(zkUrl), transport);
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    @VisibleForTesting
    static Connection fromZookeeper(DynamicBrokerSelector dynamicBrokerSelector, PinotClientTransport transport) {
        return ConnectionFactory.fromZookeeper(new Properties(), dynamicBrokerSelector, transport);
    }

    @VisibleForTesting
    static Connection fromZookeeper(Properties properties, DynamicBrokerSelector dynamicBrokerSelector, PinotClientTransport transport) {
        return new Connection(properties, dynamicBrokerSelector, transport);
    }

    public static Connection fromProperties(Properties properties) {
        return ConnectionFactory.fromProperties(properties, ConnectionFactory.getDefault(properties));
    }

    public static Connection fromProperties(Properties properties, PinotClientTransport transport) {
        return new Connection(properties, Arrays.asList(properties.getProperty("brokerList").split(",")), transport);
    }

    public static Connection fromHostList(String ... brokers) {
        return ConnectionFactory.fromHostList(Arrays.asList(brokers), ConnectionFactory.getDefault());
    }

    public static Connection fromHostList(List<String> brokers, PinotClientTransport transport) {
        return new Connection(brokers, transport);
    }

    public static Connection fromHostList(Properties properties, List<String> brokers, PinotClientTransport transport) {
        return new Connection(properties, brokers, transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PinotClientTransport getDefault(Properties connectionProperties) {
        if (_defaultTransport != null) return _defaultTransport;
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (_defaultTransport != null) return _defaultTransport;
            _defaultTransport = new JsonAsyncHttpPinotClientTransportFactory().withConnectionProperties(connectionProperties).buildTransport();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _defaultTransport;
        }
    }

    private static PinotClientTransport getDefault() {
        return ConnectionFactory.getDefault(new Properties());
    }
}

