/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.BytesPushThroughSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.ExternalViewReader;

public class DynamicBrokerSelector
implements BrokerSelector,
IZkDataListener {
    private static final Random RANDOM = new Random();
    private final AtomicReference<Map<String, List<String>>> _tableToBrokerListMapRef = new AtomicReference();
    private final AtomicReference<List<String>> _allBrokerListRef = new AtomicReference();
    private final ZkClient _zkClient;
    private final ExternalViewReader _evReader;
    private final List<String> _brokerList;

    public DynamicBrokerSelector(String zkServers, boolean preferTlsPort) {
        this._zkClient = this.getZkClient(zkServers);
        this._zkClient.setZkSerializer((ZkSerializer)new BytesPushThroughSerializer());
        this._zkClient.waitUntilConnected(60L, TimeUnit.SECONDS);
        this._zkClient.subscribeDataChanges("/EXTERNALVIEW/brokerResource", (IZkDataListener)this);
        this._evReader = this.getEvReader(this._zkClient, preferTlsPort);
        this._brokerList = ImmutableList.of((Object)zkServers);
        this.refresh();
    }

    public DynamicBrokerSelector(String zkServers) {
        this(zkServers, false);
    }

    @VisibleForTesting
    protected ZkClient getZkClient(String zkServers) {
        return new ZkClient(zkServers);
    }

    @VisibleForTesting
    protected ExternalViewReader getEvReader(ZkClient zkClient) {
        return this.getEvReader(zkClient, false);
    }

    @VisibleForTesting
    protected ExternalViewReader getEvReader(ZkClient zkClient, boolean preferTlsPort) {
        return new ExternalViewReader(zkClient, preferTlsPort);
    }

    private void refresh() {
        Map<String, List<String>> tableToBrokerListMap = this._evReader.getTableToBrokersMap();
        this._tableToBrokerListMapRef.set(tableToBrokerListMap);
        HashSet<String> brokerSet = new HashSet<String>();
        for (List<String> brokerList : tableToBrokerListMap.values()) {
            brokerSet.addAll(brokerList);
        }
        this._allBrokerListRef.set(new ArrayList(brokerSet));
    }

    @Override
    @Nullable
    public String selectBroker(String table) {
        List<String> list;
        if (table != null) {
            String tableName = table.replace("_OFFLINE", "").replace("_REALTIME", "");
            List<String> list2 = this._tableToBrokerListMapRef.get().get(tableName);
            if (list2 != null && !list2.isEmpty()) {
                return list2.get(RANDOM.nextInt(list2.size()));
            }
            int idx = tableName.indexOf(46);
            if (idx > 0) {
                tableName = tableName.substring(idx + 1);
            }
            if ((list2 = this._tableToBrokerListMapRef.get().get(tableName)) != null && !list2.isEmpty()) {
                return list2.get(RANDOM.nextInt(list2.size()));
            }
        }
        if ((list = this._allBrokerListRef.get()) != null && !list.isEmpty()) {
            return list.get(RANDOM.nextInt(list.size()));
        }
        return null;
    }

    @Override
    public List<String> getBrokers() {
        return this._brokerList;
    }

    @Override
    public void close() {
        this._zkClient.close();
    }

    public void handleDataChange(String dataPath, Object data) {
        this.refresh();
    }

    public void handleDataDeleted(String dataPath) {
        this.refresh();
    }
}

