/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;

public class ExecutionStats {
    private static final String NUM_SERVERS_QUERIED = "numServersQueried";
    private static final String NUM_SERVERS_RESPONDED = "numServersResponded";
    private static final String NUM_DOCS_SCANNED = "numDocsScanned";
    private static final String NUM_ENTRIES_SCANNED_IN_FILTER = "numEntriesScannedInFilter";
    private static final String NUM_ENTRIES_SCANNED_POST_FILTER = "numEntriesScannedPostFilter";
    private static final String NUM_SEGMENTS_QUERIED = "numSegmentsQueried";
    private static final String NUM_SEGMENTS_PROCESSED = "numSegmentsProcessed";
    private static final String NUM_SEGMENTS_MATCHED = "numSegmentsMatched";
    private static final String NUM_CONSUMING_SEGMENTS_QUERIED = "numConsumingSegmentsQueried";
    private static final String MIN_CONSUMING_FRESHNESS_TIME_MS = "minConsumingFreshnessTimeMs";
    private static final String TOTAL_DOCS = "totalDocs";
    private static final String NUM_GROUPS_LIMIT_REACHED = "numGroupsLimitReached";
    private static final String TIME_USED_MS = "timeUsedMs";
    private final JsonNode _brokerResponse;

    ExecutionStats(JsonNode brokerResponse) {
        this._brokerResponse = brokerResponse;
    }

    public static ExecutionStats fromJson(JsonNode json) {
        return new ExecutionStats(json);
    }

    public int getNumServersQueried() {
        return this._brokerResponse.has(NUM_SERVERS_QUERIED) ? this._brokerResponse.get(NUM_SERVERS_QUERIED).asInt() : -1;
    }

    public int getNumServersResponded() {
        return this._brokerResponse.has(NUM_SERVERS_RESPONDED) ? this._brokerResponse.get(NUM_SERVERS_RESPONDED).asInt() : -1;
    }

    public long getNumDocsScanned() {
        return this._brokerResponse.has(NUM_DOCS_SCANNED) ? this._brokerResponse.get(NUM_DOCS_SCANNED).asLong() : -1L;
    }

    public long getNumEntriesScannedInFilter() {
        return this._brokerResponse.has(NUM_ENTRIES_SCANNED_IN_FILTER) ? this._brokerResponse.get(NUM_ENTRIES_SCANNED_IN_FILTER).asLong() : -1L;
    }

    public long getNumEntriesScannedPostFilter() {
        return this._brokerResponse.has(NUM_ENTRIES_SCANNED_POST_FILTER) ? this._brokerResponse.get(NUM_ENTRIES_SCANNED_POST_FILTER).asLong() : -1L;
    }

    public long getNumSegmentsQueried() {
        return this._brokerResponse.has(NUM_SEGMENTS_QUERIED) ? this._brokerResponse.get(NUM_SEGMENTS_QUERIED).asLong() : -1L;
    }

    public long getNumSegmentsProcessed() {
        return this._brokerResponse.has(NUM_SEGMENTS_PROCESSED) ? this._brokerResponse.get(NUM_SEGMENTS_PROCESSED).asLong() : -1L;
    }

    public long getNumSegmentsMatched() {
        return this._brokerResponse.has(NUM_SEGMENTS_MATCHED) ? this._brokerResponse.get(NUM_SEGMENTS_MATCHED).asLong() : -1L;
    }

    public long getNumConsumingSegmentsQueried() {
        return this._brokerResponse.has(NUM_CONSUMING_SEGMENTS_QUERIED) ? this._brokerResponse.get(NUM_CONSUMING_SEGMENTS_QUERIED).asLong() : -1L;
    }

    public long getMinConsumingFreshnessTimeMs() {
        return this._brokerResponse.has(MIN_CONSUMING_FRESHNESS_TIME_MS) ? this._brokerResponse.get(MIN_CONSUMING_FRESHNESS_TIME_MS).asLong() : -1L;
    }

    public long getTotalDocs() {
        return this._brokerResponse.has(TOTAL_DOCS) ? this._brokerResponse.get(TOTAL_DOCS).asLong() : -1L;
    }

    public boolean isNumGroupsLimitReached() {
        return this._brokerResponse.has(NUM_GROUPS_LIMIT_REACHED) && this._brokerResponse.get(NUM_GROUPS_LIMIT_REACHED).asBoolean();
    }

    public long getTimeUsedMs() {
        return this._brokerResponse.has(TIME_USED_MS) ? this._brokerResponse.get(TIME_USED_MS).asLong() : -1L;
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(NUM_SERVERS_QUERIED, this.getNumServersQueried());
        map.put(NUM_SERVERS_RESPONDED, this.getNumServersResponded());
        map.put(NUM_DOCS_SCANNED, this.getNumDocsScanned());
        map.put(NUM_ENTRIES_SCANNED_IN_FILTER, this.getNumEntriesScannedInFilter());
        map.put(NUM_ENTRIES_SCANNED_POST_FILTER, this.getNumEntriesScannedPostFilter());
        map.put(NUM_SEGMENTS_QUERIED, this.getNumSegmentsQueried());
        map.put(NUM_SEGMENTS_PROCESSED, this.getNumSegmentsProcessed());
        map.put(NUM_SEGMENTS_MATCHED, this.getNumSegmentsMatched());
        map.put(NUM_CONSUMING_SEGMENTS_QUERIED, this.getNumConsumingSegmentsQueried());
        map.put(MIN_CONSUMING_FRESHNESS_TIME_MS, this.getMinConsumingFreshnessTimeMs() + "ms");
        map.put(TOTAL_DOCS, this.getTotalDocs());
        map.put(NUM_GROUPS_LIMIT_REACHED, this.isNumGroupsLimitReached());
        map.put(TIME_USED_MS, this.getTimeUsedMs() + "ms");
        return ((Object)map).toString();
    }
}

