/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.utils;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtils.class);
    public static final String INFO_HEADERS = "headers";
    public static final String PINOT_JAVA_TLS_PREFIX = "pinot.java_client.tls";
    public static final int APP_ID_MAX_CHARS = 256;

    private ConnectionUtils() {
    }

    public static Map<String, String> getHeadersFromProperties(Properties info) {
        return info.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith("headers.")).map(entry -> Pair.of((Object)entry.getKey().toString().substring(INFO_HEADERS.length() + 1), (Object)entry.getValue().toString())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static SSLContext getSSLContextFromProperties(Properties properties) {
        TlsConfig tlsConfig = TlsUtils.extractTlsConfig((PinotConfiguration)new PinotConfiguration((Configuration)new MapConfiguration(properties)), (String)PINOT_JAVA_TLS_PREFIX);
        TlsUtils.installDefaultSSLSocketFactory((TlsConfig)tlsConfig);
        return TlsUtils.getSslContext();
    }

    public static String getUserAgentVersionFromClassPath(String userAgentKey, @Nullable String appId) {
        Properties userAgentProperties = new Properties();
        try {
            userAgentProperties.load(ConnectionUtils.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to set user agent version");
        }
        String userAgentFromProperties = userAgentProperties.getProperty(userAgentKey, "unknown");
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            return appId.substring(0, Math.min(256, appId.length())) + "-" + userAgentFromProperties;
        }
        return userAgentFromProperties;
    }
}

