/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.ExecutionStats;

class BrokerResponse {
    private JsonNode _aggregationResults;
    private JsonNode _selectionResults;
    private JsonNode _resultTable;
    private JsonNode _exceptions;
    private ExecutionStats _executionStats;

    private BrokerResponse() {
    }

    private BrokerResponse(JsonNode brokerResponse) {
        this._aggregationResults = brokerResponse.get("aggregationResults");
        this._exceptions = brokerResponse.get("exceptions");
        this._selectionResults = brokerResponse.get("selectionResults");
        this._resultTable = brokerResponse.get("resultTable");
        this._executionStats = ExecutionStats.fromJson(brokerResponse);
    }

    boolean hasExceptions() {
        return this._exceptions != null && this._exceptions.size() != 0;
    }

    JsonNode getExceptions() {
        return this._exceptions;
    }

    JsonNode getAggregationResults() {
        return this._aggregationResults;
    }

    JsonNode getSelectionResults() {
        return this._selectionResults;
    }

    JsonNode getResultTable() {
        return this._resultTable;
    }

    int getAggregationResultsSize() {
        if (this._aggregationResults == null) {
            return 0;
        }
        return this._aggregationResults.size();
    }

    ExecutionStats getExecutionStats() {
        return this._executionStats;
    }

    static BrokerResponse fromJson(JsonNode json) {
        return new BrokerResponse(json);
    }

    static BrokerResponse empty() {
        return new BrokerResponse();
    }
}

