/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PreparedStatement;
import org.apache.pinot.client.Request;
import org.apache.pinot.client.ResultSetGroup;
import org.apache.pinot.client.SimpleBrokerSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final PinotClientTransport _transport;
    private final BrokerSelector _brokerSelector;
    private List<String> _brokerList;

    Connection(List<String> brokerList, PinotClientTransport transport) {
        this._brokerList = brokerList;
        LOGGER.info("Creating connection to broker list {}", brokerList);
        this._brokerSelector = new SimpleBrokerSelector(brokerList);
        this._transport = transport;
    }

    Connection(BrokerSelector brokerSelector, PinotClientTransport transport) {
        this._brokerSelector = brokerSelector;
        this._transport = transport;
    }

    @Deprecated
    public PreparedStatement prepareStatement(String query) {
        return new PreparedStatement(this, query);
    }

    public PreparedStatement prepareStatement(Request request) {
        return new PreparedStatement(this, request);
    }

    @Deprecated
    public ResultSetGroup execute(String query) throws PinotClientException {
        return this.execute(null, new Request("pql", query));
    }

    public ResultSetGroup execute(Request request) throws PinotClientException {
        return this.execute(null, request);
    }

    @Deprecated
    public ResultSetGroup execute(String tableName, String query) throws PinotClientException {
        return this.execute(tableName, new Request("pql", query));
    }

    public ResultSetGroup execute(String tableName, Request request) throws PinotClientException {
        String brokerHostPort = this._brokerSelector.selectBroker(tableName);
        if (brokerHostPort == null) {
            throw new PinotClientException("Could not find broker to query for table: " + (tableName == null ? "null" : tableName));
        }
        BrokerResponse response = this._transport.executeQuery(brokerHostPort, request);
        if (response.hasExceptions()) {
            throw new PinotClientException("Query had processing exceptions: \n" + response.getExceptions());
        }
        return new ResultSetGroup(response);
    }

    @Deprecated
    public Future<ResultSetGroup> executeAsync(String query) throws PinotClientException {
        return this.executeAsync(new Request("pql", query));
    }

    public Future<ResultSetGroup> executeAsync(Request request) throws PinotClientException {
        String brokerHostPort = this._brokerSelector.selectBroker(null);
        if (brokerHostPort == null) {
            throw new PinotClientException("Could not find broker to query for statement: " + (request.getQuery() == null ? "null" : request.getQuery()));
        }
        Future<BrokerResponse> responseFuture = this._transport.executeQueryAsync(brokerHostPort, request);
        return new ResultSetGroupFuture(responseFuture);
    }

    List<String> getBrokerList() {
        return this._brokerList;
    }

    public void close() throws PinotClientException {
        this._transport.close();
    }

    private static class ResultSetGroupFuture
    implements Future<ResultSetGroup> {
        private final Future<BrokerResponse> _responseFuture;

        public ResultSetGroupFuture(Future<BrokerResponse> responseFuture) {
            this._responseFuture = responseFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._responseFuture.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this._responseFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._responseFuture.isDone();
        }

        @Override
        public ResultSetGroup get() throws InterruptedException, ExecutionException {
            try {
                return this.get(1000L, TimeUnit.DAYS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public ResultSetGroup get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            BrokerResponse response = this._responseFuture.get(timeout, unit);
            return new ResultSetGroup(response);
        }
    }
}

