/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.DynamicBrokerSelector;
import org.apache.pinot.client.JsonAsyncHttpPinotClientTransportFactory;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransportFactory;

public class ConnectionFactory {
    static PinotClientTransportFactory _transportFactory = new JsonAsyncHttpPinotClientTransportFactory();

    private ConnectionFactory() {
    }

    public static Connection fromZookeeper(String zkUrl) {
        try {
            DynamicBrokerSelector dynamicBrokerSelector = new DynamicBrokerSelector(zkUrl);
            return new Connection(dynamicBrokerSelector, _transportFactory.buildTransport(null));
        }
        catch (Exception e) {
            throw new PinotClientException(e);
        }
    }

    public static Connection fromProperties(Properties properties) {
        return new Connection(Arrays.asList(properties.getProperty("brokerList").split(",")), _transportFactory.buildTransport(null));
    }

    public static Connection fromHostList(String ... brokers) {
        return new Connection(Arrays.asList(brokers), _transportFactory.buildTransport(null));
    }

    public static Connection fromHostList(List<String> brokers, Map<String, String> headers) {
        return new Connection(brokers, _transportFactory.buildTransport(headers));
    }
}

