/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.BytesPushThroughSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.ExternalViewReader;

public class DynamicBrokerSelector
implements BrokerSelector,
IZkDataListener {
    AtomicReference<Map<String, List<String>>> tableToBrokerListMapRef = new AtomicReference();
    AtomicReference<List<String>> allBrokerListRef = new AtomicReference();
    private final Random _random = new Random();
    private ExternalViewReader evReader;

    public DynamicBrokerSelector(String zkServers) {
        ZkClient zkClient = this.getZkClient(zkServers);
        zkClient.setZkSerializer((ZkSerializer)new BytesPushThroughSerializer());
        zkClient.waitUntilConnected(60L, TimeUnit.SECONDS);
        zkClient.subscribeDataChanges(ExternalViewReader.BROKER_EXTERNAL_VIEW_PATH, (IZkDataListener)this);
        this.evReader = this.getEvReader(zkClient);
        this.refresh();
    }

    protected ZkClient getZkClient(String zkServers) {
        return new ZkClient(zkServers);
    }

    protected ExternalViewReader getEvReader(ZkClient zkClient) {
        return new ExternalViewReader(zkClient);
    }

    private void refresh() {
        Map<String, List<String>> tableToBrokerListMap = this.evReader.getTableToBrokersMap();
        this.tableToBrokerListMapRef.set(tableToBrokerListMap);
        HashSet<String> brokerSet = new HashSet<String>();
        for (List<String> brokerList : tableToBrokerListMap.values()) {
            brokerSet.addAll(brokerList);
        }
        this.allBrokerListRef.set(new ArrayList(brokerSet));
    }

    @Override
    @Nullable
    public String selectBroker(String table) {
        if (table == null) {
            List<String> list = this.allBrokerListRef.get();
            if (list != null && !list.isEmpty()) {
                return list.get(this._random.nextInt(list.size()));
            }
            return null;
        }
        String tableName = table.replace(ExternalViewReader.OFFLINE_SUFFIX, "").replace(ExternalViewReader.REALTIME_SUFFIX, "");
        List<String> list = this.tableToBrokerListMapRef.get().get(tableName);
        if (list != null && !list.isEmpty()) {
            return list.get(this._random.nextInt(list.size()));
        }
        return null;
    }

    public void handleDataChange(String dataPath, Object data) throws Exception {
        this.refresh();
    }

    public void handleDataDeleted(String dataPath) throws Exception {
        this.refresh();
    }
}

